package zio.aws.mturk.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.mturk.model.primitives.CustomerId
import scala.jdk.CollectionConverters._
final case class CreateWorkerBlockRequest(
    workerId: CustomerId,
    reason: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.CreateWorkerBlockRequest = {
    import CreateWorkerBlockRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.CreateWorkerBlockRequest
      .builder()
      .workerId(CustomerId.unwrap(workerId): java.lang.String)
      .reason(reason: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mturk.model.CreateWorkerBlockRequest.ReadOnly =
    zio.aws.mturk.model.CreateWorkerBlockRequest.wrap(buildAwsValue())
}
object CreateWorkerBlockRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.CreateWorkerBlockRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.CreateWorkerBlockRequest =
      zio.aws.mturk.model.CreateWorkerBlockRequest(workerId, reason)
    def workerId: CustomerId
    def reason: String
    def getWorkerId: ZIO[Any, Nothing, CustomerId] = ZIO.succeed(workerId)
    def getReason: ZIO[Any, Nothing, String] = ZIO.succeed(reason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.CreateWorkerBlockRequest
  ) extends zio.aws.mturk.model.CreateWorkerBlockRequest.ReadOnly {
    override val workerId: CustomerId =
      zio.aws.mturk.model.primitives.CustomerId(impl.workerId())
    override val reason: String = impl.reason(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.CreateWorkerBlockRequest
  ): zio.aws.mturk.model.CreateWorkerBlockRequest.ReadOnly = new Wrapper(impl)
}
