package zio.aws.mturk.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.mturk.model.primitives.EntityId
import scala.jdk.CollectionConverters._
final case class DeleteHitRequest(hitId: EntityId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.DeleteHitRequest = {
    import DeleteHitRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.DeleteHitRequest
      .builder()
      .hitId(EntityId.unwrap(hitId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mturk.model.DeleteHitRequest.ReadOnly =
    zio.aws.mturk.model.DeleteHitRequest.wrap(buildAwsValue())
}
object DeleteHitRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.DeleteHitRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.DeleteHitRequest =
      zio.aws.mturk.model.DeleteHitRequest(hitId)
    def hitId: EntityId
    def getHitId: ZIO[Any, Nothing, EntityId] = ZIO.succeed(hitId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.DeleteHitRequest
  ) extends zio.aws.mturk.model.DeleteHitRequest.ReadOnly {
    override val hitId: EntityId =
      zio.aws.mturk.model.primitives.EntityId(impl.hitId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.DeleteHitRequest
  ): zio.aws.mturk.model.DeleteHitRequest.ReadOnly = new Wrapper(impl)
}
