package zio.aws.mturk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mturk.model.primitives.CustomerId
import scala.jdk.CollectionConverters._
final case class DeleteWorkerBlockRequest(
    workerId: CustomerId,
    reason: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.DeleteWorkerBlockRequest = {
    import DeleteWorkerBlockRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.DeleteWorkerBlockRequest
      .builder()
      .workerId(CustomerId.unwrap(workerId): java.lang.String)
      .optionallyWith(reason.map(value => value: java.lang.String))(_.reason)
      .build()
  }
  def asReadOnly: zio.aws.mturk.model.DeleteWorkerBlockRequest.ReadOnly =
    zio.aws.mturk.model.DeleteWorkerBlockRequest.wrap(buildAwsValue())
}
object DeleteWorkerBlockRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.DeleteWorkerBlockRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.DeleteWorkerBlockRequest =
      zio.aws.mturk.model
        .DeleteWorkerBlockRequest(workerId, reason.map(value => value))
    def workerId: CustomerId
    def reason: Option[String]
    def getWorkerId: ZIO[Any, Nothing, CustomerId] = ZIO.succeed(workerId)
    def getReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("reason", reason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.DeleteWorkerBlockRequest
  ) extends zio.aws.mturk.model.DeleteWorkerBlockRequest.ReadOnly {
    override val workerId: CustomerId =
      zio.aws.mturk.model.primitives.CustomerId(impl.workerId())
    override val reason: Option[String] =
      scala.Option(impl.reason()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.DeleteWorkerBlockRequest
  ): zio.aws.mturk.model.DeleteWorkerBlockRequest.ReadOnly = new Wrapper(impl)
}
