package zio.aws.mturk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mturk.model.primitives.{EntityId, CustomerId}
import scala.jdk.CollectionConverters._
final case class DisassociateQualificationFromWorkerRequest(
    workerId: CustomerId,
    qualificationTypeId: EntityId,
    reason: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.DisassociateQualificationFromWorkerRequest = {
    import DisassociateQualificationFromWorkerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.DisassociateQualificationFromWorkerRequest
      .builder()
      .workerId(CustomerId.unwrap(workerId): java.lang.String)
      .qualificationTypeId(
        EntityId.unwrap(qualificationTypeId): java.lang.String
      )
      .optionallyWith(reason.map(value => value: java.lang.String))(_.reason)
      .build()
  }
  def asReadOnly
      : zio.aws.mturk.model.DisassociateQualificationFromWorkerRequest.ReadOnly =
    zio.aws.mturk.model.DisassociateQualificationFromWorkerRequest
      .wrap(buildAwsValue())
}
object DisassociateQualificationFromWorkerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.DisassociateQualificationFromWorkerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.mturk.model.DisassociateQualificationFromWorkerRequest =
      zio.aws.mturk.model.DisassociateQualificationFromWorkerRequest(
        workerId,
        qualificationTypeId,
        reason.map(value => value)
      )
    def workerId: CustomerId
    def qualificationTypeId: EntityId
    def reason: Option[String]
    def getWorkerId: ZIO[Any, Nothing, CustomerId] = ZIO.succeed(workerId)
    def getQualificationTypeId: ZIO[Any, Nothing, EntityId] =
      ZIO.succeed(qualificationTypeId)
    def getReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("reason", reason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.DisassociateQualificationFromWorkerRequest
  ) extends zio.aws.mturk.model.DisassociateQualificationFromWorkerRequest.ReadOnly {
    override val workerId: CustomerId =
      zio.aws.mturk.model.primitives.CustomerId(impl.workerId())
    override val qualificationTypeId: EntityId =
      zio.aws.mturk.model.primitives.EntityId(impl.qualificationTypeId())
    override val reason: Option[String] =
      scala.Option(impl.reason()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.DisassociateQualificationFromWorkerRequest
  ): zio.aws.mturk.model.DisassociateQualificationFromWorkerRequest.ReadOnly =
    new Wrapper(impl)
}
