package zio.aws.mturk.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.mturk.model.primitives.EntityId
import scala.jdk.CollectionConverters._
final case class GetFileUploadUrlRequest(
    assignmentId: EntityId,
    questionIdentifier: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.GetFileUploadUrlRequest = {
    import GetFileUploadUrlRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.GetFileUploadUrlRequest
      .builder()
      .assignmentId(EntityId.unwrap(assignmentId): java.lang.String)
      .questionIdentifier(questionIdentifier: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mturk.model.GetFileUploadUrlRequest.ReadOnly =
    zio.aws.mturk.model.GetFileUploadUrlRequest.wrap(buildAwsValue())
}
object GetFileUploadUrlRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.GetFileUploadUrlRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.GetFileUploadUrlRequest =
      zio.aws.mturk.model
        .GetFileUploadUrlRequest(assignmentId, questionIdentifier)
    def assignmentId: EntityId
    def questionIdentifier: String
    def getAssignmentId: ZIO[Any, Nothing, EntityId] = ZIO.succeed(assignmentId)
    def getQuestionIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(questionIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.GetFileUploadUrlRequest
  ) extends zio.aws.mturk.model.GetFileUploadUrlRequest.ReadOnly {
    override val assignmentId: EntityId =
      zio.aws.mturk.model.primitives.EntityId(impl.assignmentId())
    override val questionIdentifier: String = impl.questionIdentifier(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.GetFileUploadUrlRequest
  ): zio.aws.mturk.model.GetFileUploadUrlRequest.ReadOnly = new Wrapper(impl)
}
