package zio.aws.mturk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetFileUploadUrlResponse(
    fileUploadURL: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.GetFileUploadUrlResponse = {
    import GetFileUploadUrlResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.GetFileUploadUrlResponse
      .builder()
      .optionallyWith(fileUploadURL.map(value => value: java.lang.String))(
        _.fileUploadURL
      )
      .build()
  }
  def asReadOnly: zio.aws.mturk.model.GetFileUploadUrlResponse.ReadOnly =
    zio.aws.mturk.model.GetFileUploadUrlResponse.wrap(buildAwsValue())
}
object GetFileUploadUrlResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.GetFileUploadUrlResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.GetFileUploadUrlResponse =
      zio.aws.mturk.model
        .GetFileUploadUrlResponse(fileUploadURL.map(value => value))
    def fileUploadURL: Option[String]
    def getFileUploadURL: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("fileUploadURL", fileUploadURL)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.GetFileUploadUrlResponse
  ) extends zio.aws.mturk.model.GetFileUploadUrlResponse.ReadOnly {
    override val fileUploadURL: Option[String] =
      scala.Option(impl.fileUploadURL()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.GetFileUploadUrlResponse
  ): zio.aws.mturk.model.GetFileUploadUrlResponse.ReadOnly = new Wrapper(impl)
}
