package zio.aws.mturk.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.mturk.model.primitives.EntityId
import scala.jdk.CollectionConverters._
final case class GetHitRequest(hitId: EntityId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.GetHitRequest = {
    import GetHitRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.GetHitRequest
      .builder()
      .hitId(EntityId.unwrap(hitId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mturk.model.GetHitRequest.ReadOnly =
    zio.aws.mturk.model.GetHitRequest.wrap(buildAwsValue())
}
object GetHitRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.GetHitRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.GetHitRequest =
      zio.aws.mturk.model.GetHitRequest(hitId)
    def hitId: EntityId
    def getHitId: ZIO[Any, Nothing, EntityId] = ZIO.succeed(hitId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.GetHitRequest
  ) extends zio.aws.mturk.model.GetHitRequest.ReadOnly {
    override val hitId: EntityId =
      zio.aws.mturk.model.primitives.EntityId(impl.hitId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.GetHitRequest
  ): zio.aws.mturk.model.GetHitRequest.ReadOnly = new Wrapper(impl)
}
