package zio.aws.mturk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetQualificationTypeResponse(
    qualificationType: Option[zio.aws.mturk.model.QualificationType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.GetQualificationTypeResponse = {
    import GetQualificationTypeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.GetQualificationTypeResponse
      .builder()
      .optionallyWith(qualificationType.map(value => value.buildAwsValue()))(
        _.qualificationType
      )
      .build()
  }
  def asReadOnly: zio.aws.mturk.model.GetQualificationTypeResponse.ReadOnly =
    zio.aws.mturk.model.GetQualificationTypeResponse.wrap(buildAwsValue())
}
object GetQualificationTypeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.GetQualificationTypeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.GetQualificationTypeResponse =
      zio.aws.mturk.model.GetQualificationTypeResponse(
        qualificationType.map(value => value.asEditable)
      )
    def qualificationType
        : Option[zio.aws.mturk.model.QualificationType.ReadOnly]
    def getQualificationType
        : ZIO[Any, AwsError, zio.aws.mturk.model.QualificationType.ReadOnly] =
      AwsError.unwrapOptionField("qualificationType", qualificationType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.GetQualificationTypeResponse
  ) extends zio.aws.mturk.model.GetQualificationTypeResponse.ReadOnly {
    override val qualificationType
        : Option[zio.aws.mturk.model.QualificationType.ReadOnly] = scala
      .Option(impl.qualificationType())
      .map(value => zio.aws.mturk.model.QualificationType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.GetQualificationTypeResponse
  ): zio.aws.mturk.model.GetQualificationTypeResponse.ReadOnly = new Wrapper(
    impl
  )
}
