package zio.aws.mturk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mturk.model.primitives.{
  CurrencyAmount,
  Integer,
  Timestamp,
  EntityId
}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class HIT(
    hitId: Option[EntityId] = None,
    hitTypeId: Option[EntityId] = None,
    hitGroupId: Option[EntityId] = None,
    hitLayoutId: Option[EntityId] = None,
    creationTime: Option[Timestamp] = None,
    title: Option[String] = None,
    description: Option[String] = None,
    question: Option[String] = None,
    keywords: Option[String] = None,
    hitStatus: Option[zio.aws.mturk.model.HITStatus] = None,
    maxAssignments: Option[Integer] = None,
    reward: Option[CurrencyAmount] = None,
    autoApprovalDelayInSeconds: Option[Long] = None,
    expiration: Option[Timestamp] = None,
    assignmentDurationInSeconds: Option[Long] = None,
    requesterAnnotation: Option[String] = None,
    qualificationRequirements: Option[
      Iterable[zio.aws.mturk.model.QualificationRequirement]
    ] = None,
    hitReviewStatus: Option[zio.aws.mturk.model.HITReviewStatus] = None,
    numberOfAssignmentsPending: Option[Integer] = None,
    numberOfAssignmentsAvailable: Option[Integer] = None,
    numberOfAssignmentsCompleted: Option[Integer] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.mturk.model.HIT = {
    import HIT.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.HIT
      .builder()
      .optionallyWith(
        hitId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.hitId)
      .optionallyWith(
        hitTypeId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.hitTypeId)
      .optionallyWith(
        hitGroupId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.hitGroupId)
      .optionallyWith(
        hitLayoutId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.hitLayoutId)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(title.map(value => value: java.lang.String))(_.title)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(question.map(value => value: java.lang.String))(
        _.question
      )
      .optionallyWith(keywords.map(value => value: java.lang.String))(
        _.keywords
      )
      .optionallyWith(hitStatus.map(value => value.unwrap))(_.hitStatus)
      .optionallyWith(maxAssignments.map(value => value: java.lang.Integer))(
        _.maxAssignments
      )
      .optionallyWith(
        reward.map(value => CurrencyAmount.unwrap(value): java.lang.String)
      )(_.reward)
      .optionallyWith(
        autoApprovalDelayInSeconds.map(value => value: java.lang.Long)
      )(_.autoApprovalDelayInSeconds)
      .optionallyWith(
        expiration.map(value => Timestamp.unwrap(value): Instant)
      )(_.expiration)
      .optionallyWith(
        assignmentDurationInSeconds.map(value => value: java.lang.Long)
      )(_.assignmentDurationInSeconds)
      .optionallyWith(
        requesterAnnotation.map(value => value: java.lang.String)
      )(_.requesterAnnotation)
      .optionallyWith(
        qualificationRequirements.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.qualificationRequirements)
      .optionallyWith(hitReviewStatus.map(value => value.unwrap))(
        _.hitReviewStatus
      )
      .optionallyWith(
        numberOfAssignmentsPending.map(value => value: java.lang.Integer)
      )(_.numberOfAssignmentsPending)
      .optionallyWith(
        numberOfAssignmentsAvailable.map(value => value: java.lang.Integer)
      )(_.numberOfAssignmentsAvailable)
      .optionallyWith(
        numberOfAssignmentsCompleted.map(value => value: java.lang.Integer)
      )(_.numberOfAssignmentsCompleted)
      .build()
  }
  def asReadOnly: zio.aws.mturk.model.HIT.ReadOnly =
    zio.aws.mturk.model.HIT.wrap(buildAwsValue())
}
object HIT {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.mturk.model.HIT] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.HIT = zio.aws.mturk.model.HIT(
      hitId.map(value => value),
      hitTypeId.map(value => value),
      hitGroupId.map(value => value),
      hitLayoutId.map(value => value),
      creationTime.map(value => value),
      title.map(value => value),
      description.map(value => value),
      question.map(value => value),
      keywords.map(value => value),
      hitStatus.map(value => value),
      maxAssignments.map(value => value),
      reward.map(value => value),
      autoApprovalDelayInSeconds.map(value => value),
      expiration.map(value => value),
      assignmentDurationInSeconds.map(value => value),
      requesterAnnotation.map(value => value),
      qualificationRequirements.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      hitReviewStatus.map(value => value),
      numberOfAssignmentsPending.map(value => value),
      numberOfAssignmentsAvailable.map(value => value),
      numberOfAssignmentsCompleted.map(value => value)
    )
    def hitId: Option[EntityId]
    def hitTypeId: Option[EntityId]
    def hitGroupId: Option[EntityId]
    def hitLayoutId: Option[EntityId]
    def creationTime: Option[Timestamp]
    def title: Option[String]
    def description: Option[String]
    def question: Option[String]
    def keywords: Option[String]
    def hitStatus: Option[zio.aws.mturk.model.HITStatus]
    def maxAssignments: Option[Integer]
    def reward: Option[CurrencyAmount]
    def autoApprovalDelayInSeconds: Option[Long]
    def expiration: Option[Timestamp]
    def assignmentDurationInSeconds: Option[Long]
    def requesterAnnotation: Option[String]
    def qualificationRequirements
        : Option[List[zio.aws.mturk.model.QualificationRequirement.ReadOnly]]
    def hitReviewStatus: Option[zio.aws.mturk.model.HITReviewStatus]
    def numberOfAssignmentsPending: Option[Integer]
    def numberOfAssignmentsAvailable: Option[Integer]
    def numberOfAssignmentsCompleted: Option[Integer]
    def getHitId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("hitId", hitId)
    def getHitTypeId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("hitTypeId", hitTypeId)
    def getHitGroupId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("hitGroupId", hitGroupId)
    def getHitLayoutId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("hitLayoutId", hitLayoutId)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getTitle: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("title", title)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getQuestion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("question", question)
    def getKeywords: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("keywords", keywords)
    def getHitStatus: ZIO[Any, AwsError, zio.aws.mturk.model.HITStatus] =
      AwsError.unwrapOptionField("hitStatus", hitStatus)
    def getMaxAssignments: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxAssignments", maxAssignments)
    def getReward: ZIO[Any, AwsError, CurrencyAmount] =
      AwsError.unwrapOptionField("reward", reward)
    def getAutoApprovalDelayInSeconds: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField(
        "autoApprovalDelayInSeconds",
        autoApprovalDelayInSeconds
      )
    def getExpiration: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("expiration", expiration)
    def getAssignmentDurationInSeconds: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField(
        "assignmentDurationInSeconds",
        assignmentDurationInSeconds
      )
    def getRequesterAnnotation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("requesterAnnotation", requesterAnnotation)
    def getQualificationRequirements: ZIO[Any, AwsError, List[
      zio.aws.mturk.model.QualificationRequirement.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "qualificationRequirements",
      qualificationRequirements
    )
    def getHitReviewStatus
        : ZIO[Any, AwsError, zio.aws.mturk.model.HITReviewStatus] =
      AwsError.unwrapOptionField("hitReviewStatus", hitReviewStatus)
    def getNumberOfAssignmentsPending: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "numberOfAssignmentsPending",
        numberOfAssignmentsPending
      )
    def getNumberOfAssignmentsAvailable: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "numberOfAssignmentsAvailable",
        numberOfAssignmentsAvailable
      )
    def getNumberOfAssignmentsCompleted: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "numberOfAssignmentsCompleted",
        numberOfAssignmentsCompleted
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.HIT
  ) extends zio.aws.mturk.model.HIT.ReadOnly {
    override val hitId: Option[EntityId] = scala
      .Option(impl.hitId())
      .map(value => zio.aws.mturk.model.primitives.EntityId(value))
    override val hitTypeId: Option[EntityId] = scala
      .Option(impl.hitTypeId())
      .map(value => zio.aws.mturk.model.primitives.EntityId(value))
    override val hitGroupId: Option[EntityId] = scala
      .Option(impl.hitGroupId())
      .map(value => zio.aws.mturk.model.primitives.EntityId(value))
    override val hitLayoutId: Option[EntityId] = scala
      .Option(impl.hitLayoutId())
      .map(value => zio.aws.mturk.model.primitives.EntityId(value))
    override val creationTime: Option[Timestamp] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.mturk.model.primitives.Timestamp(value))
    override val title: Option[String] =
      scala.Option(impl.title()).map(value => value: String)
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val question: Option[String] =
      scala.Option(impl.question()).map(value => value: String)
    override val keywords: Option[String] =
      scala.Option(impl.keywords()).map(value => value: String)
    override val hitStatus: Option[zio.aws.mturk.model.HITStatus] = scala
      .Option(impl.hitStatus())
      .map(value => zio.aws.mturk.model.HITStatus.wrap(value))
    override val maxAssignments: Option[Integer] =
      scala.Option(impl.maxAssignments()).map(value => value: Integer)
    override val reward: Option[CurrencyAmount] = scala
      .Option(impl.reward())
      .map(value => zio.aws.mturk.model.primitives.CurrencyAmount(value))
    override val autoApprovalDelayInSeconds: Option[Long] =
      scala.Option(impl.autoApprovalDelayInSeconds()).map(value => value: Long)
    override val expiration: Option[Timestamp] = scala
      .Option(impl.expiration())
      .map(value => zio.aws.mturk.model.primitives.Timestamp(value))
    override val assignmentDurationInSeconds: Option[Long] =
      scala.Option(impl.assignmentDurationInSeconds()).map(value => value: Long)
    override val requesterAnnotation: Option[String] =
      scala.Option(impl.requesterAnnotation()).map(value => value: String)
    override val qualificationRequirements
        : Option[List[zio.aws.mturk.model.QualificationRequirement.ReadOnly]] =
      scala
        .Option(impl.qualificationRequirements())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.mturk.model.QualificationRequirement.wrap(item)
          }.toList
        )
    override val hitReviewStatus: Option[zio.aws.mturk.model.HITReviewStatus] =
      scala
        .Option(impl.hitReviewStatus())
        .map(value => zio.aws.mturk.model.HITReviewStatus.wrap(value))
    override val numberOfAssignmentsPending: Option[Integer] = scala
      .Option(impl.numberOfAssignmentsPending())
      .map(value => value: Integer)
    override val numberOfAssignmentsAvailable: Option[Integer] = scala
      .Option(impl.numberOfAssignmentsAvailable())
      .map(value => value: Integer)
    override val numberOfAssignmentsCompleted: Option[Integer] = scala
      .Option(impl.numberOfAssignmentsCompleted())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.HIT
  ): zio.aws.mturk.model.HIT.ReadOnly = new Wrapper(impl)
}
