package zio.aws.mturk.model
import scala.jdk.CollectionConverters._
sealed trait HITAccessActions {
  def unwrap: software.amazon.awssdk.services.mturk.model.HITAccessActions
}
object HITAccessActions {
  def wrap(
      value: software.amazon.awssdk.services.mturk.model.HITAccessActions
  ): zio.aws.mturk.model.HITAccessActions = value match {
    case software.amazon.awssdk.services.mturk.model.HITAccessActions.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mturk.model.HITAccessActions.ACCEPT =>
      val r = Accept
      r
    case software.amazon.awssdk.services.mturk.model.HITAccessActions.PREVIEW_AND_ACCEPT =>
      val r = PreviewAndAccept
      r
    case software.amazon.awssdk.services.mturk.model.HITAccessActions.DISCOVER_PREVIEW_AND_ACCEPT =>
      val r = DiscoverPreviewAndAccept
      r
  }
  case object unknownToSdkVersion extends zio.aws.mturk.model.HITAccessActions {
    override def unwrap
        : software.amazon.awssdk.services.mturk.model.HITAccessActions =
      software.amazon.awssdk.services.mturk.model.HITAccessActions.UNKNOWN_TO_SDK_VERSION
  }
  case object Accept extends zio.aws.mturk.model.HITAccessActions {
    override def unwrap
        : software.amazon.awssdk.services.mturk.model.HITAccessActions =
      software.amazon.awssdk.services.mturk.model.HITAccessActions.ACCEPT
  }
  case object PreviewAndAccept extends zio.aws.mturk.model.HITAccessActions {
    override def unwrap
        : software.amazon.awssdk.services.mturk.model.HITAccessActions =
      software.amazon.awssdk.services.mturk.model.HITAccessActions.PREVIEW_AND_ACCEPT
  }
  case object DiscoverPreviewAndAccept
      extends zio.aws.mturk.model.HITAccessActions {
    override def unwrap
        : software.amazon.awssdk.services.mturk.model.HITAccessActions =
      software.amazon.awssdk.services.mturk.model.HITAccessActions.DISCOVER_PREVIEW_AND_ACCEPT
  }
}
