package zio.aws.mturk.model
import scala.jdk.CollectionConverters._
sealed trait HITReviewStatus {
  def unwrap: software.amazon.awssdk.services.mturk.model.HITReviewStatus
}
object HITReviewStatus {
  def wrap(
      value: software.amazon.awssdk.services.mturk.model.HITReviewStatus
  ): zio.aws.mturk.model.HITReviewStatus = value match {
    case software.amazon.awssdk.services.mturk.model.HITReviewStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mturk.model.HITReviewStatus.NOT_REVIEWED =>
      val r = NotReviewed
      r
    case software.amazon.awssdk.services.mturk.model.HITReviewStatus.MARKED_FOR_REVIEW =>
      val r = MarkedForReview
      r
    case software.amazon.awssdk.services.mturk.model.HITReviewStatus.REVIEWED_APPROPRIATE =>
      val r = ReviewedAppropriate
      r
    case software.amazon.awssdk.services.mturk.model.HITReviewStatus.REVIEWED_INAPPROPRIATE =>
      val r = ReviewedInappropriate
      r
  }
  case object unknownToSdkVersion extends zio.aws.mturk.model.HITReviewStatus {
    override def unwrap
        : software.amazon.awssdk.services.mturk.model.HITReviewStatus =
      software.amazon.awssdk.services.mturk.model.HITReviewStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object NotReviewed extends zio.aws.mturk.model.HITReviewStatus {
    override def unwrap
        : software.amazon.awssdk.services.mturk.model.HITReviewStatus =
      software.amazon.awssdk.services.mturk.model.HITReviewStatus.NOT_REVIEWED
  }
  case object MarkedForReview extends zio.aws.mturk.model.HITReviewStatus {
    override def unwrap
        : software.amazon.awssdk.services.mturk.model.HITReviewStatus =
      software.amazon.awssdk.services.mturk.model.HITReviewStatus.MARKED_FOR_REVIEW
  }
  case object ReviewedAppropriate extends zio.aws.mturk.model.HITReviewStatus {
    override def unwrap
        : software.amazon.awssdk.services.mturk.model.HITReviewStatus =
      software.amazon.awssdk.services.mturk.model.HITReviewStatus.REVIEWED_APPROPRIATE
  }
  case object ReviewedInappropriate
      extends zio.aws.mturk.model.HITReviewStatus {
    override def unwrap
        : software.amazon.awssdk.services.mturk.model.HITReviewStatus =
      software.amazon.awssdk.services.mturk.model.HITReviewStatus.REVIEWED_INAPPROPRIATE
  }
}
