package zio.aws.mturk.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mturk.model.primitives.{ResultSize, PaginationToken, EntityId}
import scala.jdk.CollectionConverters._
final case class ListAssignmentsForHitRequest(
    hitId: EntityId,
    nextToken: Option[PaginationToken] = None,
    maxResults: Option[ResultSize] = None,
    assignmentStatuses: Option[Iterable[zio.aws.mturk.model.AssignmentStatus]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.ListAssignmentsForHitRequest = {
    import ListAssignmentsForHitRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.ListAssignmentsForHitRequest
      .builder()
      .hitId(EntityId.unwrap(hitId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => ResultSize.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        assignmentStatuses.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.assignmentStatusesWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.mturk.model.ListAssignmentsForHitRequest.ReadOnly =
    zio.aws.mturk.model.ListAssignmentsForHitRequest.wrap(buildAwsValue())
}
object ListAssignmentsForHitRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.ListAssignmentsForHitRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.ListAssignmentsForHitRequest =
      zio.aws.mturk.model.ListAssignmentsForHitRequest(
        hitId,
        nextToken.map(value => value),
        maxResults.map(value => value),
        assignmentStatuses.map(value => value)
      )
    def hitId: EntityId
    def nextToken: Option[PaginationToken]
    def maxResults: Option[ResultSize]
    def assignmentStatuses: Option[List[zio.aws.mturk.model.AssignmentStatus]]
    def getHitId: ZIO[Any, Nothing, EntityId] = ZIO.succeed(hitId)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, ResultSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getAssignmentStatuses
        : ZIO[Any, AwsError, List[zio.aws.mturk.model.AssignmentStatus]] =
      AwsError.unwrapOptionField("assignmentStatuses", assignmentStatuses)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.ListAssignmentsForHitRequest
  ) extends zio.aws.mturk.model.ListAssignmentsForHitRequest.ReadOnly {
    override val hitId: EntityId =
      zio.aws.mturk.model.primitives.EntityId(impl.hitId())
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.mturk.model.primitives.PaginationToken(value))
    override val maxResults: Option[ResultSize] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.mturk.model.primitives.ResultSize(value))
    override val assignmentStatuses
        : Option[List[zio.aws.mturk.model.AssignmentStatus]] = scala
      .Option(impl.assignmentStatuses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mturk.model.AssignmentStatus.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.ListAssignmentsForHitRequest
  ): zio.aws.mturk.model.ListAssignmentsForHitRequest.ReadOnly = new Wrapper(
    impl
  )
}
