package zio.aws.mturk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mturk.model.primitives.{Integer, PaginationToken}
import scala.jdk.CollectionConverters._
final case class ListAssignmentsForHitResponse(
    nextToken: Option[PaginationToken] = None,
    numResults: Option[Integer] = None,
    assignments: Option[Iterable[zio.aws.mturk.model.Assignment]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.ListAssignmentsForHitResponse = {
    import ListAssignmentsForHitResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.ListAssignmentsForHitResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(numResults.map(value => value: java.lang.Integer))(
        _.numResults
      )
      .optionallyWith(
        assignments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.assignments)
      .build()
  }
  def asReadOnly: zio.aws.mturk.model.ListAssignmentsForHitResponse.ReadOnly =
    zio.aws.mturk.model.ListAssignmentsForHitResponse.wrap(buildAwsValue())
}
object ListAssignmentsForHitResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.ListAssignmentsForHitResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.ListAssignmentsForHitResponse =
      zio.aws.mturk.model.ListAssignmentsForHitResponse(
        nextToken.map(value => value),
        numResults.map(value => value),
        assignments.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[PaginationToken]
    def numResults: Option[Integer]
    def assignments: Option[List[zio.aws.mturk.model.Assignment.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getNumResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("numResults", numResults)
    def getAssignments
        : ZIO[Any, AwsError, List[zio.aws.mturk.model.Assignment.ReadOnly]] =
      AwsError.unwrapOptionField("assignments", assignments)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.ListAssignmentsForHitResponse
  ) extends zio.aws.mturk.model.ListAssignmentsForHitResponse.ReadOnly {
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.mturk.model.primitives.PaginationToken(value))
    override val numResults: Option[Integer] =
      scala.Option(impl.numResults()).map(value => value: Integer)
    override val assignments
        : Option[List[zio.aws.mturk.model.Assignment.ReadOnly]] = scala
      .Option(impl.assignments())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mturk.model.Assignment.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.ListAssignmentsForHitResponse
  ): zio.aws.mturk.model.ListAssignmentsForHitResponse.ReadOnly = new Wrapper(
    impl
  )
}
