package zio.aws.mturk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mturk.model.primitives.{PaginationToken, Integer}
import scala.jdk.CollectionConverters._
final case class ListBonusPaymentsResponse(
    numResults: Option[Integer] = None,
    nextToken: Option[PaginationToken] = None,
    bonusPayments: Option[Iterable[zio.aws.mturk.model.BonusPayment]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.ListBonusPaymentsResponse = {
    import ListBonusPaymentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.ListBonusPaymentsResponse
      .builder()
      .optionallyWith(numResults.map(value => value: java.lang.Integer))(
        _.numResults
      )
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        bonusPayments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.bonusPayments)
      .build()
  }
  def asReadOnly: zio.aws.mturk.model.ListBonusPaymentsResponse.ReadOnly =
    zio.aws.mturk.model.ListBonusPaymentsResponse.wrap(buildAwsValue())
}
object ListBonusPaymentsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.ListBonusPaymentsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.ListBonusPaymentsResponse =
      zio.aws.mturk.model.ListBonusPaymentsResponse(
        numResults.map(value => value),
        nextToken.map(value => value),
        bonusPayments.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def numResults: Option[Integer]
    def nextToken: Option[PaginationToken]
    def bonusPayments: Option[List[zio.aws.mturk.model.BonusPayment.ReadOnly]]
    def getNumResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("numResults", numResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getBonusPayments
        : ZIO[Any, AwsError, List[zio.aws.mturk.model.BonusPayment.ReadOnly]] =
      AwsError.unwrapOptionField("bonusPayments", bonusPayments)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.ListBonusPaymentsResponse
  ) extends zio.aws.mturk.model.ListBonusPaymentsResponse.ReadOnly {
    override val numResults: Option[Integer] =
      scala.Option(impl.numResults()).map(value => value: Integer)
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.mturk.model.primitives.PaginationToken(value))
    override val bonusPayments
        : Option[List[zio.aws.mturk.model.BonusPayment.ReadOnly]] = scala
      .Option(impl.bonusPayments())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mturk.model.BonusPayment.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.ListBonusPaymentsResponse
  ): zio.aws.mturk.model.ListBonusPaymentsResponse.ReadOnly = new Wrapper(impl)
}
