package zio.aws.mturk.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mturk.model.primitives.{ResultSize, PaginationToken, EntityId}
import scala.jdk.CollectionConverters._
final case class ListQualificationRequestsRequest(
    qualificationTypeId: Option[EntityId] = None,
    nextToken: Option[PaginationToken] = None,
    maxResults: Option[ResultSize] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.ListQualificationRequestsRequest = {
    import ListQualificationRequestsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.ListQualificationRequestsRequest
      .builder()
      .optionallyWith(
        qualificationTypeId.map(value =>
          EntityId.unwrap(value): java.lang.String
        )
      )(_.qualificationTypeId)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => ResultSize.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.mturk.model.ListQualificationRequestsRequest.ReadOnly =
    zio.aws.mturk.model.ListQualificationRequestsRequest.wrap(buildAwsValue())
}
object ListQualificationRequestsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.ListQualificationRequestsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.ListQualificationRequestsRequest =
      zio.aws.mturk.model.ListQualificationRequestsRequest(
        qualificationTypeId.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def qualificationTypeId: Option[EntityId]
    def nextToken: Option[PaginationToken]
    def maxResults: Option[ResultSize]
    def getQualificationTypeId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("qualificationTypeId", qualificationTypeId)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, ResultSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.ListQualificationRequestsRequest
  ) extends zio.aws.mturk.model.ListQualificationRequestsRequest.ReadOnly {
    override val qualificationTypeId: Option[EntityId] = scala
      .Option(impl.qualificationTypeId())
      .map(value => zio.aws.mturk.model.primitives.EntityId(value))
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.mturk.model.primitives.PaginationToken(value))
    override val maxResults: Option[ResultSize] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.mturk.model.primitives.ResultSize(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.ListQualificationRequestsRequest
  ): zio.aws.mturk.model.ListQualificationRequestsRequest.ReadOnly =
    new Wrapper(impl)
}
