package zio.aws.mturk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mturk.model.primitives.{PaginationToken, Integer}
import scala.jdk.CollectionConverters._
final case class ListQualificationRequestsResponse(
    numResults: Option[Integer] = None,
    nextToken: Option[PaginationToken] = None,
    qualificationRequests: Option[
      Iterable[zio.aws.mturk.model.QualificationRequest]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.ListQualificationRequestsResponse = {
    import ListQualificationRequestsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.ListQualificationRequestsResponse
      .builder()
      .optionallyWith(numResults.map(value => value: java.lang.Integer))(
        _.numResults
      )
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        qualificationRequests.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.qualificationRequests)
      .build()
  }
  def asReadOnly
      : zio.aws.mturk.model.ListQualificationRequestsResponse.ReadOnly =
    zio.aws.mturk.model.ListQualificationRequestsResponse.wrap(buildAwsValue())
}
object ListQualificationRequestsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.ListQualificationRequestsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.ListQualificationRequestsResponse =
      zio.aws.mturk.model.ListQualificationRequestsResponse(
        numResults.map(value => value),
        nextToken.map(value => value),
        qualificationRequests.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def numResults: Option[Integer]
    def nextToken: Option[PaginationToken]
    def qualificationRequests
        : Option[List[zio.aws.mturk.model.QualificationRequest.ReadOnly]]
    def getNumResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("numResults", numResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getQualificationRequests: ZIO[Any, AwsError, List[
      zio.aws.mturk.model.QualificationRequest.ReadOnly
    ]] =
      AwsError.unwrapOptionField("qualificationRequests", qualificationRequests)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.ListQualificationRequestsResponse
  ) extends zio.aws.mturk.model.ListQualificationRequestsResponse.ReadOnly {
    override val numResults: Option[Integer] =
      scala.Option(impl.numResults()).map(value => value: Integer)
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.mturk.model.primitives.PaginationToken(value))
    override val qualificationRequests
        : Option[List[zio.aws.mturk.model.QualificationRequest.ReadOnly]] =
      scala
        .Option(impl.qualificationRequests())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.mturk.model.QualificationRequest.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.ListQualificationRequestsResponse
  ): zio.aws.mturk.model.ListQualificationRequestsResponse.ReadOnly =
    new Wrapper(impl)
}
