package zio.aws.mturk.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mturk.model.primitives.{ResultSize, PaginationToken}
import scala.jdk.CollectionConverters._
final case class ListQualificationTypesRequest(
    query: Option[String] = None,
    mustBeRequestable: Boolean,
    mustBeOwnedByCaller: Option[Boolean] = None,
    nextToken: Option[PaginationToken] = None,
    maxResults: Option[ResultSize] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.ListQualificationTypesRequest = {
    import ListQualificationTypesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.ListQualificationTypesRequest
      .builder()
      .optionallyWith(query.map(value => value: java.lang.String))(_.query)
      .mustBeRequestable(mustBeRequestable: java.lang.Boolean)
      .optionallyWith(
        mustBeOwnedByCaller.map(value => value: java.lang.Boolean)
      )(_.mustBeOwnedByCaller)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => ResultSize.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.mturk.model.ListQualificationTypesRequest.ReadOnly =
    zio.aws.mturk.model.ListQualificationTypesRequest.wrap(buildAwsValue())
}
object ListQualificationTypesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.ListQualificationTypesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.ListQualificationTypesRequest =
      zio.aws.mturk.model.ListQualificationTypesRequest(
        query.map(value => value),
        mustBeRequestable,
        mustBeOwnedByCaller.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def query: Option[String]
    def mustBeRequestable: Boolean
    def mustBeOwnedByCaller: Option[Boolean]
    def nextToken: Option[PaginationToken]
    def maxResults: Option[ResultSize]
    def getQuery: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("query", query)
    def getMustBeRequestable: ZIO[Any, Nothing, Boolean] =
      ZIO.succeed(mustBeRequestable)
    def getMustBeOwnedByCaller: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("mustBeOwnedByCaller", mustBeOwnedByCaller)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, ResultSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.ListQualificationTypesRequest
  ) extends zio.aws.mturk.model.ListQualificationTypesRequest.ReadOnly {
    override val query: Option[String] =
      scala.Option(impl.query()).map(value => value: String)
    override val mustBeRequestable: Boolean = impl.mustBeRequestable(): Boolean
    override val mustBeOwnedByCaller: Option[Boolean] =
      scala.Option(impl.mustBeOwnedByCaller()).map(value => value: Boolean)
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.mturk.model.primitives.PaginationToken(value))
    override val maxResults: Option[ResultSize] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.mturk.model.primitives.ResultSize(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.ListQualificationTypesRequest
  ): zio.aws.mturk.model.ListQualificationTypesRequest.ReadOnly = new Wrapper(
    impl
  )
}
