package zio.aws.mturk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mturk.model.primitives.{PaginationToken, Integer}
import scala.jdk.CollectionConverters._
final case class ListQualificationTypesResponse(
    numResults: Option[Integer] = None,
    nextToken: Option[PaginationToken] = None,
    qualificationTypes: Option[
      Iterable[zio.aws.mturk.model.QualificationType]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.ListQualificationTypesResponse = {
    import ListQualificationTypesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.ListQualificationTypesResponse
      .builder()
      .optionallyWith(numResults.map(value => value: java.lang.Integer))(
        _.numResults
      )
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        qualificationTypes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.qualificationTypes)
      .build()
  }
  def asReadOnly: zio.aws.mturk.model.ListQualificationTypesResponse.ReadOnly =
    zio.aws.mturk.model.ListQualificationTypesResponse.wrap(buildAwsValue())
}
object ListQualificationTypesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.ListQualificationTypesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.ListQualificationTypesResponse =
      zio.aws.mturk.model.ListQualificationTypesResponse(
        numResults.map(value => value),
        nextToken.map(value => value),
        qualificationTypes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def numResults: Option[Integer]
    def nextToken: Option[PaginationToken]
    def qualificationTypes
        : Option[List[zio.aws.mturk.model.QualificationType.ReadOnly]]
    def getNumResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("numResults", numResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getQualificationTypes: ZIO[Any, AwsError, List[
      zio.aws.mturk.model.QualificationType.ReadOnly
    ]] = AwsError.unwrapOptionField("qualificationTypes", qualificationTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.ListQualificationTypesResponse
  ) extends zio.aws.mturk.model.ListQualificationTypesResponse.ReadOnly {
    override val numResults: Option[Integer] =
      scala.Option(impl.numResults()).map(value => value: Integer)
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.mturk.model.primitives.PaginationToken(value))
    override val qualificationTypes
        : Option[List[zio.aws.mturk.model.QualificationType.ReadOnly]] = scala
      .Option(impl.qualificationTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mturk.model.QualificationType.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.ListQualificationTypesResponse
  ): zio.aws.mturk.model.ListQualificationTypesResponse.ReadOnly = new Wrapper(
    impl
  )
}
