package zio.aws.mturk.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mturk.model.primitives.{ResultSize, PaginationToken, EntityId}
import scala.jdk.CollectionConverters._
final case class ListReviewPolicyResultsForHitRequest(
    hitId: EntityId,
    policyLevels: Option[Iterable[zio.aws.mturk.model.ReviewPolicyLevel]] =
      None,
    retrieveActions: Option[Boolean] = None,
    retrieveResults: Option[Boolean] = None,
    nextToken: Option[PaginationToken] = None,
    maxResults: Option[ResultSize] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.ListReviewPolicyResultsForHitRequest = {
    import ListReviewPolicyResultsForHitRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.ListReviewPolicyResultsForHitRequest
      .builder()
      .hitId(EntityId.unwrap(hitId): java.lang.String)
      .optionallyWith(
        policyLevels.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.policyLevelsWithStrings)
      .optionallyWith(retrieveActions.map(value => value: java.lang.Boolean))(
        _.retrieveActions
      )
      .optionallyWith(retrieveResults.map(value => value: java.lang.Boolean))(
        _.retrieveResults
      )
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => ResultSize.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.mturk.model.ListReviewPolicyResultsForHitRequest.ReadOnly =
    zio.aws.mturk.model.ListReviewPolicyResultsForHitRequest
      .wrap(buildAwsValue())
}
object ListReviewPolicyResultsForHitRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.ListReviewPolicyResultsForHitRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.ListReviewPolicyResultsForHitRequest =
      zio.aws.mturk.model.ListReviewPolicyResultsForHitRequest(
        hitId,
        policyLevels.map(value => value),
        retrieveActions.map(value => value),
        retrieveResults.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def hitId: EntityId
    def policyLevels: Option[List[zio.aws.mturk.model.ReviewPolicyLevel]]
    def retrieveActions: Option[Boolean]
    def retrieveResults: Option[Boolean]
    def nextToken: Option[PaginationToken]
    def maxResults: Option[ResultSize]
    def getHitId: ZIO[Any, Nothing, EntityId] = ZIO.succeed(hitId)
    def getPolicyLevels
        : ZIO[Any, AwsError, List[zio.aws.mturk.model.ReviewPolicyLevel]] =
      AwsError.unwrapOptionField("policyLevels", policyLevels)
    def getRetrieveActions: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("retrieveActions", retrieveActions)
    def getRetrieveResults: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("retrieveResults", retrieveResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, ResultSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.ListReviewPolicyResultsForHitRequest
  ) extends zio.aws.mturk.model.ListReviewPolicyResultsForHitRequest.ReadOnly {
    override val hitId: EntityId =
      zio.aws.mturk.model.primitives.EntityId(impl.hitId())
    override val policyLevels
        : Option[List[zio.aws.mturk.model.ReviewPolicyLevel]] = scala
      .Option(impl.policyLevels())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mturk.model.ReviewPolicyLevel.wrap(item)
        }.toList
      )
    override val retrieveActions: Option[Boolean] =
      scala.Option(impl.retrieveActions()).map(value => value: Boolean)
    override val retrieveResults: Option[Boolean] =
      scala.Option(impl.retrieveResults()).map(value => value: Boolean)
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.mturk.model.primitives.PaginationToken(value))
    override val maxResults: Option[ResultSize] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.mturk.model.primitives.ResultSize(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.ListReviewPolicyResultsForHitRequest
  ): zio.aws.mturk.model.ListReviewPolicyResultsForHitRequest.ReadOnly =
    new Wrapper(impl)
}
