package zio.aws.mturk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mturk.model.primitives.{PaginationToken, EntityId}
import scala.jdk.CollectionConverters._
final case class ListReviewPolicyResultsForHitResponse(
    hitId: Option[EntityId] = None,
    assignmentReviewPolicy: Option[zio.aws.mturk.model.ReviewPolicy] = None,
    hitReviewPolicy: Option[zio.aws.mturk.model.ReviewPolicy] = None,
    assignmentReviewReport: Option[zio.aws.mturk.model.ReviewReport] = None,
    hitReviewReport: Option[zio.aws.mturk.model.ReviewReport] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.ListReviewPolicyResultsForHitResponse = {
    import ListReviewPolicyResultsForHitResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.ListReviewPolicyResultsForHitResponse
      .builder()
      .optionallyWith(
        hitId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.hitId)
      .optionallyWith(
        assignmentReviewPolicy.map(value => value.buildAwsValue())
      )(_.assignmentReviewPolicy)
      .optionallyWith(hitReviewPolicy.map(value => value.buildAwsValue()))(
        _.hitReviewPolicy
      )
      .optionallyWith(
        assignmentReviewReport.map(value => value.buildAwsValue())
      )(_.assignmentReviewReport)
      .optionallyWith(hitReviewReport.map(value => value.buildAwsValue()))(
        _.hitReviewReport
      )
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.mturk.model.ListReviewPolicyResultsForHitResponse.ReadOnly =
    zio.aws.mturk.model.ListReviewPolicyResultsForHitResponse
      .wrap(buildAwsValue())
}
object ListReviewPolicyResultsForHitResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.ListReviewPolicyResultsForHitResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.ListReviewPolicyResultsForHitResponse =
      zio.aws.mturk.model.ListReviewPolicyResultsForHitResponse(
        hitId.map(value => value),
        assignmentReviewPolicy.map(value => value.asEditable),
        hitReviewPolicy.map(value => value.asEditable),
        assignmentReviewReport.map(value => value.asEditable),
        hitReviewReport.map(value => value.asEditable),
        nextToken.map(value => value)
      )
    def hitId: Option[EntityId]
    def assignmentReviewPolicy
        : Option[zio.aws.mturk.model.ReviewPolicy.ReadOnly]
    def hitReviewPolicy: Option[zio.aws.mturk.model.ReviewPolicy.ReadOnly]
    def assignmentReviewReport
        : Option[zio.aws.mturk.model.ReviewReport.ReadOnly]
    def hitReviewReport: Option[zio.aws.mturk.model.ReviewReport.ReadOnly]
    def nextToken: Option[PaginationToken]
    def getHitId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("hitId", hitId)
    def getAssignmentReviewPolicy
        : ZIO[Any, AwsError, zio.aws.mturk.model.ReviewPolicy.ReadOnly] =
      AwsError.unwrapOptionField(
        "assignmentReviewPolicy",
        assignmentReviewPolicy
      )
    def getHitReviewPolicy
        : ZIO[Any, AwsError, zio.aws.mturk.model.ReviewPolicy.ReadOnly] =
      AwsError.unwrapOptionField("hitReviewPolicy", hitReviewPolicy)
    def getAssignmentReviewReport
        : ZIO[Any, AwsError, zio.aws.mturk.model.ReviewReport.ReadOnly] =
      AwsError.unwrapOptionField(
        "assignmentReviewReport",
        assignmentReviewReport
      )
    def getHitReviewReport
        : ZIO[Any, AwsError, zio.aws.mturk.model.ReviewReport.ReadOnly] =
      AwsError.unwrapOptionField("hitReviewReport", hitReviewReport)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.ListReviewPolicyResultsForHitResponse
  ) extends zio.aws.mturk.model.ListReviewPolicyResultsForHitResponse.ReadOnly {
    override val hitId: Option[EntityId] = scala
      .Option(impl.hitId())
      .map(value => zio.aws.mturk.model.primitives.EntityId(value))
    override val assignmentReviewPolicy
        : Option[zio.aws.mturk.model.ReviewPolicy.ReadOnly] = scala
      .Option(impl.assignmentReviewPolicy())
      .map(value => zio.aws.mturk.model.ReviewPolicy.wrap(value))
    override val hitReviewPolicy
        : Option[zio.aws.mturk.model.ReviewPolicy.ReadOnly] = scala
      .Option(impl.hitReviewPolicy())
      .map(value => zio.aws.mturk.model.ReviewPolicy.wrap(value))
    override val assignmentReviewReport
        : Option[zio.aws.mturk.model.ReviewReport.ReadOnly] = scala
      .Option(impl.assignmentReviewReport())
      .map(value => zio.aws.mturk.model.ReviewReport.wrap(value))
    override val hitReviewReport
        : Option[zio.aws.mturk.model.ReviewReport.ReadOnly] = scala
      .Option(impl.hitReviewReport())
      .map(value => zio.aws.mturk.model.ReviewReport.wrap(value))
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.mturk.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.ListReviewPolicyResultsForHitResponse
  ): zio.aws.mturk.model.ListReviewPolicyResultsForHitResponse.ReadOnly =
    new Wrapper(impl)
}
