package zio.aws.mturk.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mturk.model.primitives.{ResultSize, PaginationToken, EntityId}
import scala.jdk.CollectionConverters._
final case class ListReviewableHiTsRequest(
    hitTypeId: Option[EntityId] = None,
    status: Option[zio.aws.mturk.model.ReviewableHITStatus] = None,
    nextToken: Option[PaginationToken] = None,
    maxResults: Option[ResultSize] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.ListReviewableHiTsRequest = {
    import ListReviewableHiTsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.ListReviewableHiTsRequest
      .builder()
      .optionallyWith(
        hitTypeId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.hitTypeId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => ResultSize.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.mturk.model.ListReviewableHiTsRequest.ReadOnly =
    zio.aws.mturk.model.ListReviewableHiTsRequest.wrap(buildAwsValue())
}
object ListReviewableHiTsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.ListReviewableHiTsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.ListReviewableHiTsRequest =
      zio.aws.mturk.model.ListReviewableHiTsRequest(
        hitTypeId.map(value => value),
        status.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def hitTypeId: Option[EntityId]
    def status: Option[zio.aws.mturk.model.ReviewableHITStatus]
    def nextToken: Option[PaginationToken]
    def maxResults: Option[ResultSize]
    def getHitTypeId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("hitTypeId", hitTypeId)
    def getStatus: ZIO[Any, AwsError, zio.aws.mturk.model.ReviewableHITStatus] =
      AwsError.unwrapOptionField("status", status)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, ResultSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.ListReviewableHiTsRequest
  ) extends zio.aws.mturk.model.ListReviewableHiTsRequest.ReadOnly {
    override val hitTypeId: Option[EntityId] = scala
      .Option(impl.hitTypeId())
      .map(value => zio.aws.mturk.model.primitives.EntityId(value))
    override val status: Option[zio.aws.mturk.model.ReviewableHITStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.mturk.model.ReviewableHITStatus.wrap(value))
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.mturk.model.primitives.PaginationToken(value))
    override val maxResults: Option[ResultSize] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.mturk.model.primitives.ResultSize(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.ListReviewableHiTsRequest
  ): zio.aws.mturk.model.ListReviewableHiTsRequest.ReadOnly = new Wrapper(impl)
}
