package zio.aws.mturk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mturk.model.primitives.{Integer, PaginationToken}
import scala.jdk.CollectionConverters._
final case class ListReviewableHiTsResponse(
    nextToken: Option[PaginationToken] = None,
    numResults: Option[Integer] = None,
    hiTs: Option[Iterable[zio.aws.mturk.model.HIT]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.ListReviewableHiTsResponse = {
    import ListReviewableHiTsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.ListReviewableHiTsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(numResults.map(value => value: java.lang.Integer))(
        _.numResults
      )
      .optionallyWith(
        hiTs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.hiTs)
      .build()
  }
  def asReadOnly: zio.aws.mturk.model.ListReviewableHiTsResponse.ReadOnly =
    zio.aws.mturk.model.ListReviewableHiTsResponse.wrap(buildAwsValue())
}
object ListReviewableHiTsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.ListReviewableHiTsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.ListReviewableHiTsResponse =
      zio.aws.mturk.model.ListReviewableHiTsResponse(
        nextToken.map(value => value),
        numResults.map(value => value),
        hiTs.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[PaginationToken]
    def numResults: Option[Integer]
    def hiTs: Option[List[zio.aws.mturk.model.HIT.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getNumResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("numResults", numResults)
    def getHiTs: ZIO[Any, AwsError, List[zio.aws.mturk.model.HIT.ReadOnly]] =
      AwsError.unwrapOptionField("hiTs", hiTs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.ListReviewableHiTsResponse
  ) extends zio.aws.mturk.model.ListReviewableHiTsResponse.ReadOnly {
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.mturk.model.primitives.PaginationToken(value))
    override val numResults: Option[Integer] =
      scala.Option(impl.numResults()).map(value => value: Integer)
    override val hiTs: Option[List[zio.aws.mturk.model.HIT.ReadOnly]] = scala
      .Option(impl.hiTs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mturk.model.HIT.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.ListReviewableHiTsResponse
  ): zio.aws.mturk.model.ListReviewableHiTsResponse.ReadOnly = new Wrapper(impl)
}
