package zio.aws.mturk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mturk.model.primitives.{Integer, PaginationToken}
import scala.jdk.CollectionConverters._
final case class ListWorkerBlocksResponse(
    nextToken: Option[PaginationToken] = None,
    numResults: Option[Integer] = None,
    workerBlocks: Option[Iterable[zio.aws.mturk.model.WorkerBlock]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.ListWorkerBlocksResponse = {
    import ListWorkerBlocksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.ListWorkerBlocksResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(numResults.map(value => value: java.lang.Integer))(
        _.numResults
      )
      .optionallyWith(
        workerBlocks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.workerBlocks)
      .build()
  }
  def asReadOnly: zio.aws.mturk.model.ListWorkerBlocksResponse.ReadOnly =
    zio.aws.mturk.model.ListWorkerBlocksResponse.wrap(buildAwsValue())
}
object ListWorkerBlocksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.ListWorkerBlocksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.ListWorkerBlocksResponse =
      zio.aws.mturk.model.ListWorkerBlocksResponse(
        nextToken.map(value => value),
        numResults.map(value => value),
        workerBlocks.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[PaginationToken]
    def numResults: Option[Integer]
    def workerBlocks: Option[List[zio.aws.mturk.model.WorkerBlock.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getNumResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("numResults", numResults)
    def getWorkerBlocks
        : ZIO[Any, AwsError, List[zio.aws.mturk.model.WorkerBlock.ReadOnly]] =
      AwsError.unwrapOptionField("workerBlocks", workerBlocks)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.ListWorkerBlocksResponse
  ) extends zio.aws.mturk.model.ListWorkerBlocksResponse.ReadOnly {
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.mturk.model.primitives.PaginationToken(value))
    override val numResults: Option[Integer] =
      scala.Option(impl.numResults()).map(value => value: Integer)
    override val workerBlocks
        : Option[List[zio.aws.mturk.model.WorkerBlock.ReadOnly]] = scala
      .Option(impl.workerBlocks())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mturk.model.WorkerBlock.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.ListWorkerBlocksResponse
  ): zio.aws.mturk.model.ListWorkerBlocksResponse.ReadOnly = new Wrapper(impl)
}
