package zio.aws.mturk.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mturk.model.primitives.{ResultSize, PaginationToken, EntityId}
import scala.jdk.CollectionConverters._
final case class ListWorkersWithQualificationTypeRequest(
    qualificationTypeId: EntityId,
    status: Option[zio.aws.mturk.model.QualificationStatus] = None,
    nextToken: Option[PaginationToken] = None,
    maxResults: Option[ResultSize] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.ListWorkersWithQualificationTypeRequest = {
    import ListWorkersWithQualificationTypeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.ListWorkersWithQualificationTypeRequest
      .builder()
      .qualificationTypeId(
        EntityId.unwrap(qualificationTypeId): java.lang.String
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => ResultSize.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.mturk.model.ListWorkersWithQualificationTypeRequest.ReadOnly =
    zio.aws.mturk.model.ListWorkersWithQualificationTypeRequest
      .wrap(buildAwsValue())
}
object ListWorkersWithQualificationTypeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.ListWorkersWithQualificationTypeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.mturk.model.ListWorkersWithQualificationTypeRequest =
      zio.aws.mturk.model.ListWorkersWithQualificationTypeRequest(
        qualificationTypeId,
        status.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def qualificationTypeId: EntityId
    def status: Option[zio.aws.mturk.model.QualificationStatus]
    def nextToken: Option[PaginationToken]
    def maxResults: Option[ResultSize]
    def getQualificationTypeId: ZIO[Any, Nothing, EntityId] =
      ZIO.succeed(qualificationTypeId)
    def getStatus: ZIO[Any, AwsError, zio.aws.mturk.model.QualificationStatus] =
      AwsError.unwrapOptionField("status", status)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, ResultSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.ListWorkersWithQualificationTypeRequest
  ) extends zio.aws.mturk.model.ListWorkersWithQualificationTypeRequest.ReadOnly {
    override val qualificationTypeId: EntityId =
      zio.aws.mturk.model.primitives.EntityId(impl.qualificationTypeId())
    override val status: Option[zio.aws.mturk.model.QualificationStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.mturk.model.QualificationStatus.wrap(value))
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.mturk.model.primitives.PaginationToken(value))
    override val maxResults: Option[ResultSize] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.mturk.model.primitives.ResultSize(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.ListWorkersWithQualificationTypeRequest
  ): zio.aws.mturk.model.ListWorkersWithQualificationTypeRequest.ReadOnly =
    new Wrapper(impl)
}
