package zio.aws.mturk.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class NotificationSpecification(
    destination: String,
    transport: zio.aws.mturk.model.NotificationTransport,
    version: String,
    eventTypes: Iterable[zio.aws.mturk.model.EventType]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.NotificationSpecification = {
    import NotificationSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.NotificationSpecification
      .builder()
      .destination(destination: java.lang.String)
      .transport(transport.unwrap)
      .version(version: java.lang.String)
      .eventTypesWithStrings(eventTypes.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.mturk.model.NotificationSpecification.ReadOnly =
    zio.aws.mturk.model.NotificationSpecification.wrap(buildAwsValue())
}
object NotificationSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.NotificationSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.NotificationSpecification =
      zio.aws.mturk.model.NotificationSpecification(
        destination,
        transport,
        version,
        eventTypes
      )
    def destination: String
    def transport: zio.aws.mturk.model.NotificationTransport
    def version: String
    def eventTypes: List[zio.aws.mturk.model.EventType]
    def getDestination: ZIO[Any, Nothing, String] = ZIO.succeed(destination)
    def getTransport
        : ZIO[Any, Nothing, zio.aws.mturk.model.NotificationTransport] =
      ZIO.succeed(transport)
    def getVersion: ZIO[Any, Nothing, String] = ZIO.succeed(version)
    def getEventTypes: ZIO[Any, Nothing, List[zio.aws.mturk.model.EventType]] =
      ZIO.succeed(eventTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.NotificationSpecification
  ) extends zio.aws.mturk.model.NotificationSpecification.ReadOnly {
    override val destination: String = impl.destination(): String
    override val transport: zio.aws.mturk.model.NotificationTransport =
      zio.aws.mturk.model.NotificationTransport.wrap(impl.transport())
    override val version: String = impl.version(): String
    override val eventTypes: List[zio.aws.mturk.model.EventType] = impl
      .eventTypes()
      .asScala
      .map { item =>
        zio.aws.mturk.model.EventType.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.NotificationSpecification
  ): zio.aws.mturk.model.NotificationSpecification.ReadOnly = new Wrapper(impl)
}
