package zio.aws.mturk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mturk.model.primitives.CustomerId
import scala.jdk.CollectionConverters._
final case class NotifyWorkersFailureStatus(
    notifyWorkersFailureCode: Option[
      zio.aws.mturk.model.NotifyWorkersFailureCode
    ] = None,
    notifyWorkersFailureMessage: Option[String] = None,
    workerId: Option[CustomerId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.NotifyWorkersFailureStatus = {
    import NotifyWorkersFailureStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.NotifyWorkersFailureStatus
      .builder()
      .optionallyWith(notifyWorkersFailureCode.map(value => value.unwrap))(
        _.notifyWorkersFailureCode
      )
      .optionallyWith(
        notifyWorkersFailureMessage.map(value => value: java.lang.String)
      )(_.notifyWorkersFailureMessage)
      .optionallyWith(
        workerId.map(value => CustomerId.unwrap(value): java.lang.String)
      )(_.workerId)
      .build()
  }
  def asReadOnly: zio.aws.mturk.model.NotifyWorkersFailureStatus.ReadOnly =
    zio.aws.mturk.model.NotifyWorkersFailureStatus.wrap(buildAwsValue())
}
object NotifyWorkersFailureStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.NotifyWorkersFailureStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.NotifyWorkersFailureStatus =
      zio.aws.mturk.model.NotifyWorkersFailureStatus(
        notifyWorkersFailureCode.map(value => value),
        notifyWorkersFailureMessage.map(value => value),
        workerId.map(value => value)
      )
    def notifyWorkersFailureCode
        : Option[zio.aws.mturk.model.NotifyWorkersFailureCode]
    def notifyWorkersFailureMessage: Option[String]
    def workerId: Option[CustomerId]
    def getNotifyWorkersFailureCode
        : ZIO[Any, AwsError, zio.aws.mturk.model.NotifyWorkersFailureCode] =
      AwsError.unwrapOptionField(
        "notifyWorkersFailureCode",
        notifyWorkersFailureCode
      )
    def getNotifyWorkersFailureMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "notifyWorkersFailureMessage",
        notifyWorkersFailureMessage
      )
    def getWorkerId: ZIO[Any, AwsError, CustomerId] =
      AwsError.unwrapOptionField("workerId", workerId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.NotifyWorkersFailureStatus
  ) extends zio.aws.mturk.model.NotifyWorkersFailureStatus.ReadOnly {
    override val notifyWorkersFailureCode
        : Option[zio.aws.mturk.model.NotifyWorkersFailureCode] = scala
      .Option(impl.notifyWorkersFailureCode())
      .map(value => zio.aws.mturk.model.NotifyWorkersFailureCode.wrap(value))
    override val notifyWorkersFailureMessage: Option[String] = scala
      .Option(impl.notifyWorkersFailureMessage())
      .map(value => value: String)
    override val workerId: Option[CustomerId] = scala
      .Option(impl.workerId())
      .map(value => zio.aws.mturk.model.primitives.CustomerId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.NotifyWorkersFailureStatus
  ): zio.aws.mturk.model.NotifyWorkersFailureStatus.ReadOnly = new Wrapper(impl)
}
