package zio.aws.mturk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class NotifyWorkersResponse(
    notifyWorkersFailureStatuses: Option[
      Iterable[zio.aws.mturk.model.NotifyWorkersFailureStatus]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.NotifyWorkersResponse = {
    import NotifyWorkersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.NotifyWorkersResponse
      .builder()
      .optionallyWith(
        notifyWorkersFailureStatuses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.notifyWorkersFailureStatuses)
      .build()
  }
  def asReadOnly: zio.aws.mturk.model.NotifyWorkersResponse.ReadOnly =
    zio.aws.mturk.model.NotifyWorkersResponse.wrap(buildAwsValue())
}
object NotifyWorkersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.NotifyWorkersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.NotifyWorkersResponse =
      zio.aws.mturk.model.NotifyWorkersResponse(
        notifyWorkersFailureStatuses.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def notifyWorkersFailureStatuses
        : Option[List[zio.aws.mturk.model.NotifyWorkersFailureStatus.ReadOnly]]
    def getNotifyWorkersFailureStatuses: ZIO[Any, AwsError, List[
      zio.aws.mturk.model.NotifyWorkersFailureStatus.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "notifyWorkersFailureStatuses",
      notifyWorkersFailureStatuses
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.NotifyWorkersResponse
  ) extends zio.aws.mturk.model.NotifyWorkersResponse.ReadOnly {
    override val notifyWorkersFailureStatuses: Option[
      List[zio.aws.mturk.model.NotifyWorkersFailureStatus.ReadOnly]
    ] = scala
      .Option(impl.notifyWorkersFailureStatuses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mturk.model.NotifyWorkersFailureStatus.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.NotifyWorkersResponse
  ): zio.aws.mturk.model.NotifyWorkersResponse.ReadOnly = new Wrapper(impl)
}
