package zio.aws.mturk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PolicyParameter(
    key: Option[String] = None,
    values: Option[Iterable[String]] = None,
    mapEntries: Option[Iterable[zio.aws.mturk.model.ParameterMapEntry]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.PolicyParameter = {
    import PolicyParameter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.PolicyParameter
      .builder()
      .optionallyWith(key.map(value => value: java.lang.String))(_.key)
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.values)
      .optionallyWith(
        mapEntries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.mapEntries)
      .build()
  }
  def asReadOnly: zio.aws.mturk.model.PolicyParameter.ReadOnly =
    zio.aws.mturk.model.PolicyParameter.wrap(buildAwsValue())
}
object PolicyParameter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.PolicyParameter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.PolicyParameter =
      zio.aws.mturk.model.PolicyParameter(
        key.map(value => value),
        values.map(value => value),
        mapEntries.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def key: Option[String]
    def values: Option[List[String]]
    def mapEntries: Option[List[zio.aws.mturk.model.ParameterMapEntry.ReadOnly]]
    def getKey: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("key", key)
    def getValues: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("values", values)
    def getMapEntries: ZIO[Any, AwsError, List[
      zio.aws.mturk.model.ParameterMapEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("mapEntries", mapEntries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.PolicyParameter
  ) extends zio.aws.mturk.model.PolicyParameter.ReadOnly {
    override val key: Option[String] =
      scala.Option(impl.key()).map(value => value: String)
    override val values: Option[List[String]] = scala
      .Option(impl.values())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val mapEntries
        : Option[List[zio.aws.mturk.model.ParameterMapEntry.ReadOnly]] = scala
      .Option(impl.mapEntries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mturk.model.ParameterMapEntry.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.PolicyParameter
  ): zio.aws.mturk.model.PolicyParameter.ReadOnly = new Wrapper(impl)
}
