package zio.aws.mturk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mturk.model.primitives.{Integer, Timestamp, CustomerId, EntityId}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class Qualification(
    qualificationTypeId: Option[EntityId] = None,
    workerId: Option[CustomerId] = None,
    grantTime: Option[Timestamp] = None,
    integerValue: Option[Integer] = None,
    localeValue: Option[zio.aws.mturk.model.Locale] = None,
    status: Option[zio.aws.mturk.model.QualificationStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.Qualification = {
    import Qualification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.Qualification
      .builder()
      .optionallyWith(
        qualificationTypeId.map(value =>
          EntityId.unwrap(value): java.lang.String
        )
      )(_.qualificationTypeId)
      .optionallyWith(
        workerId.map(value => CustomerId.unwrap(value): java.lang.String)
      )(_.workerId)
      .optionallyWith(grantTime.map(value => Timestamp.unwrap(value): Instant))(
        _.grantTime
      )
      .optionallyWith(integerValue.map(value => value: java.lang.Integer))(
        _.integerValue
      )
      .optionallyWith(localeValue.map(value => value.buildAwsValue()))(
        _.localeValue
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.mturk.model.Qualification.ReadOnly =
    zio.aws.mturk.model.Qualification.wrap(buildAwsValue())
}
object Qualification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.Qualification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.Qualification =
      zio.aws.mturk.model.Qualification(
        qualificationTypeId.map(value => value),
        workerId.map(value => value),
        grantTime.map(value => value),
        integerValue.map(value => value),
        localeValue.map(value => value.asEditable),
        status.map(value => value)
      )
    def qualificationTypeId: Option[EntityId]
    def workerId: Option[CustomerId]
    def grantTime: Option[Timestamp]
    def integerValue: Option[Integer]
    def localeValue: Option[zio.aws.mturk.model.Locale.ReadOnly]
    def status: Option[zio.aws.mturk.model.QualificationStatus]
    def getQualificationTypeId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("qualificationTypeId", qualificationTypeId)
    def getWorkerId: ZIO[Any, AwsError, CustomerId] =
      AwsError.unwrapOptionField("workerId", workerId)
    def getGrantTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("grantTime", grantTime)
    def getIntegerValue: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("integerValue", integerValue)
    def getLocaleValue
        : ZIO[Any, AwsError, zio.aws.mturk.model.Locale.ReadOnly] =
      AwsError.unwrapOptionField("localeValue", localeValue)
    def getStatus: ZIO[Any, AwsError, zio.aws.mturk.model.QualificationStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.Qualification
  ) extends zio.aws.mturk.model.Qualification.ReadOnly {
    override val qualificationTypeId: Option[EntityId] = scala
      .Option(impl.qualificationTypeId())
      .map(value => zio.aws.mturk.model.primitives.EntityId(value))
    override val workerId: Option[CustomerId] = scala
      .Option(impl.workerId())
      .map(value => zio.aws.mturk.model.primitives.CustomerId(value))
    override val grantTime: Option[Timestamp] = scala
      .Option(impl.grantTime())
      .map(value => zio.aws.mturk.model.primitives.Timestamp(value))
    override val integerValue: Option[Integer] =
      scala.Option(impl.integerValue()).map(value => value: Integer)
    override val localeValue: Option[zio.aws.mturk.model.Locale.ReadOnly] =
      scala
        .Option(impl.localeValue())
        .map(value => zio.aws.mturk.model.Locale.wrap(value))
    override val status: Option[zio.aws.mturk.model.QualificationStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.mturk.model.QualificationStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.Qualification
  ): zio.aws.mturk.model.Qualification.ReadOnly = new Wrapper(impl)
}
