package zio.aws.mturk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mturk.model.primitives.Integer
import scala.jdk.CollectionConverters._
final case class QualificationRequirement(
    qualificationTypeId: String,
    comparator: zio.aws.mturk.model.Comparator,
    integerValues: Option[Iterable[Integer]] = None,
    localeValues: Option[Iterable[zio.aws.mturk.model.Locale]] = None,
    requiredToPreview: Option[Boolean] = None,
    actionsGuarded: Option[zio.aws.mturk.model.HITAccessActions] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.QualificationRequirement = {
    import QualificationRequirement.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.QualificationRequirement
      .builder()
      .qualificationTypeId(qualificationTypeId: java.lang.String)
      .comparator(comparator.unwrap)
      .optionallyWith(
        integerValues.map(value =>
          value.map { item =>
            item: java.lang.Integer
          }.asJavaCollection
        )
      )(_.integerValues)
      .optionallyWith(
        localeValues.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.localeValues)
      .optionallyWith(requiredToPreview.map(value => value: java.lang.Boolean))(
        _.requiredToPreview
      )
      .optionallyWith(actionsGuarded.map(value => value.unwrap))(
        _.actionsGuarded
      )
      .build()
  }
  def asReadOnly: zio.aws.mturk.model.QualificationRequirement.ReadOnly =
    zio.aws.mturk.model.QualificationRequirement.wrap(buildAwsValue())
}
object QualificationRequirement {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.QualificationRequirement
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.QualificationRequirement =
      zio.aws.mturk.model.QualificationRequirement(
        qualificationTypeId,
        comparator,
        integerValues.map(value => value),
        localeValues.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        requiredToPreview.map(value => value),
        actionsGuarded.map(value => value)
      )
    def qualificationTypeId: String
    def comparator: zio.aws.mturk.model.Comparator
    def integerValues: Option[List[Integer]]
    def localeValues: Option[List[zio.aws.mturk.model.Locale.ReadOnly]]
    def requiredToPreview: Option[Boolean]
    def actionsGuarded: Option[zio.aws.mturk.model.HITAccessActions]
    def getQualificationTypeId: ZIO[Any, Nothing, String] =
      ZIO.succeed(qualificationTypeId)
    def getComparator: ZIO[Any, Nothing, zio.aws.mturk.model.Comparator] =
      ZIO.succeed(comparator)
    def getIntegerValues: ZIO[Any, AwsError, List[Integer]] =
      AwsError.unwrapOptionField("integerValues", integerValues)
    def getLocaleValues
        : ZIO[Any, AwsError, List[zio.aws.mturk.model.Locale.ReadOnly]] =
      AwsError.unwrapOptionField("localeValues", localeValues)
    def getRequiredToPreview: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("requiredToPreview", requiredToPreview)
    def getActionsGuarded
        : ZIO[Any, AwsError, zio.aws.mturk.model.HITAccessActions] =
      AwsError.unwrapOptionField("actionsGuarded", actionsGuarded)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.QualificationRequirement
  ) extends zio.aws.mturk.model.QualificationRequirement.ReadOnly {
    override val qualificationTypeId: String =
      impl.qualificationTypeId(): String
    override val comparator: zio.aws.mturk.model.Comparator =
      zio.aws.mturk.model.Comparator.wrap(impl.comparator())
    override val integerValues: Option[List[Integer]] = scala
      .Option(impl.integerValues())
      .map(value =>
        value.asScala.map { item =>
          item: Integer
        }.toList
      )
    override val localeValues
        : Option[List[zio.aws.mturk.model.Locale.ReadOnly]] = scala
      .Option(impl.localeValues())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mturk.model.Locale.wrap(item)
        }.toList
      )
    override val requiredToPreview: Option[Boolean] =
      scala.Option(impl.requiredToPreview()).map(value => value: Boolean)
    override val actionsGuarded: Option[zio.aws.mturk.model.HITAccessActions] =
      scala
        .Option(impl.actionsGuarded())
        .map(value => zio.aws.mturk.model.HITAccessActions.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.QualificationRequirement
  ): zio.aws.mturk.model.QualificationRequirement.ReadOnly = new Wrapper(impl)
}
