package zio.aws.mturk.model
import scala.jdk.CollectionConverters._
sealed trait QualificationStatus {
  def unwrap: software.amazon.awssdk.services.mturk.model.QualificationStatus
}
object QualificationStatus {
  def wrap(
      value: software.amazon.awssdk.services.mturk.model.QualificationStatus
  ): zio.aws.mturk.model.QualificationStatus = value match {
    case software.amazon.awssdk.services.mturk.model.QualificationStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mturk.model.QualificationStatus.GRANTED =>
      val r = Granted
      r
    case software.amazon.awssdk.services.mturk.model.QualificationStatus.REVOKED =>
      val r = Revoked
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.mturk.model.QualificationStatus {
    override def unwrap
        : software.amazon.awssdk.services.mturk.model.QualificationStatus =
      software.amazon.awssdk.services.mturk.model.QualificationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Granted extends zio.aws.mturk.model.QualificationStatus {
    override def unwrap
        : software.amazon.awssdk.services.mturk.model.QualificationStatus =
      software.amazon.awssdk.services.mturk.model.QualificationStatus.GRANTED
  }
  case object Revoked extends zio.aws.mturk.model.QualificationStatus {
    override def unwrap
        : software.amazon.awssdk.services.mturk.model.QualificationStatus =
      software.amazon.awssdk.services.mturk.model.QualificationStatus.REVOKED
  }
}
