package zio.aws.mturk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mturk.model.primitives.{Integer, Timestamp, EntityId}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class QualificationType(
    qualificationTypeId: Option[EntityId] = None,
    creationTime: Option[Timestamp] = None,
    name: Option[String] = None,
    description: Option[String] = None,
    keywords: Option[String] = None,
    qualificationTypeStatus: Option[
      zio.aws.mturk.model.QualificationTypeStatus
    ] = None,
    test: Option[String] = None,
    testDurationInSeconds: Option[Long] = None,
    answerKey: Option[String] = None,
    retryDelayInSeconds: Option[Long] = None,
    isRequestable: Option[Boolean] = None,
    autoGranted: Option[Boolean] = None,
    autoGrantedValue: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.QualificationType = {
    import QualificationType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.QualificationType
      .builder()
      .optionallyWith(
        qualificationTypeId.map(value =>
          EntityId.unwrap(value): java.lang.String
        )
      )(_.qualificationTypeId)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(keywords.map(value => value: java.lang.String))(
        _.keywords
      )
      .optionallyWith(qualificationTypeStatus.map(value => value.unwrap))(
        _.qualificationTypeStatus
      )
      .optionallyWith(test.map(value => value: java.lang.String))(_.test)
      .optionallyWith(
        testDurationInSeconds.map(value => value: java.lang.Long)
      )(_.testDurationInSeconds)
      .optionallyWith(answerKey.map(value => value: java.lang.String))(
        _.answerKey
      )
      .optionallyWith(retryDelayInSeconds.map(value => value: java.lang.Long))(
        _.retryDelayInSeconds
      )
      .optionallyWith(isRequestable.map(value => value: java.lang.Boolean))(
        _.isRequestable
      )
      .optionallyWith(autoGranted.map(value => value: java.lang.Boolean))(
        _.autoGranted
      )
      .optionallyWith(autoGrantedValue.map(value => value: java.lang.Integer))(
        _.autoGrantedValue
      )
      .build()
  }
  def asReadOnly: zio.aws.mturk.model.QualificationType.ReadOnly =
    zio.aws.mturk.model.QualificationType.wrap(buildAwsValue())
}
object QualificationType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.QualificationType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.QualificationType =
      zio.aws.mturk.model.QualificationType(
        qualificationTypeId.map(value => value),
        creationTime.map(value => value),
        name.map(value => value),
        description.map(value => value),
        keywords.map(value => value),
        qualificationTypeStatus.map(value => value),
        test.map(value => value),
        testDurationInSeconds.map(value => value),
        answerKey.map(value => value),
        retryDelayInSeconds.map(value => value),
        isRequestable.map(value => value),
        autoGranted.map(value => value),
        autoGrantedValue.map(value => value)
      )
    def qualificationTypeId: Option[EntityId]
    def creationTime: Option[Timestamp]
    def name: Option[String]
    def description: Option[String]
    def keywords: Option[String]
    def qualificationTypeStatus
        : Option[zio.aws.mturk.model.QualificationTypeStatus]
    def test: Option[String]
    def testDurationInSeconds: Option[Long]
    def answerKey: Option[String]
    def retryDelayInSeconds: Option[Long]
    def isRequestable: Option[Boolean]
    def autoGranted: Option[Boolean]
    def autoGrantedValue: Option[Integer]
    def getQualificationTypeId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("qualificationTypeId", qualificationTypeId)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getKeywords: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("keywords", keywords)
    def getQualificationTypeStatus
        : ZIO[Any, AwsError, zio.aws.mturk.model.QualificationTypeStatus] =
      AwsError.unwrapOptionField(
        "qualificationTypeStatus",
        qualificationTypeStatus
      )
    def getTest: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("test", test)
    def getTestDurationInSeconds: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("testDurationInSeconds", testDurationInSeconds)
    def getAnswerKey: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("answerKey", answerKey)
    def getRetryDelayInSeconds: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("retryDelayInSeconds", retryDelayInSeconds)
    def getIsRequestable: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isRequestable", isRequestable)
    def getAutoGranted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("autoGranted", autoGranted)
    def getAutoGrantedValue: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("autoGrantedValue", autoGrantedValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.QualificationType
  ) extends zio.aws.mturk.model.QualificationType.ReadOnly {
    override val qualificationTypeId: Option[EntityId] = scala
      .Option(impl.qualificationTypeId())
      .map(value => zio.aws.mturk.model.primitives.EntityId(value))
    override val creationTime: Option[Timestamp] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.mturk.model.primitives.Timestamp(value))
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val keywords: Option[String] =
      scala.Option(impl.keywords()).map(value => value: String)
    override val qualificationTypeStatus
        : Option[zio.aws.mturk.model.QualificationTypeStatus] = scala
      .Option(impl.qualificationTypeStatus())
      .map(value => zio.aws.mturk.model.QualificationTypeStatus.wrap(value))
    override val test: Option[String] =
      scala.Option(impl.test()).map(value => value: String)
    override val testDurationInSeconds: Option[Long] =
      scala.Option(impl.testDurationInSeconds()).map(value => value: Long)
    override val answerKey: Option[String] =
      scala.Option(impl.answerKey()).map(value => value: String)
    override val retryDelayInSeconds: Option[Long] =
      scala.Option(impl.retryDelayInSeconds()).map(value => value: Long)
    override val isRequestable: Option[Boolean] =
      scala.Option(impl.isRequestable()).map(value => value: Boolean)
    override val autoGranted: Option[Boolean] =
      scala.Option(impl.autoGranted()).map(value => value: Boolean)
    override val autoGrantedValue: Option[Integer] =
      scala.Option(impl.autoGrantedValue()).map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.QualificationType
  ): zio.aws.mturk.model.QualificationType.ReadOnly = new Wrapper(impl)
}
