package zio.aws.mturk.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.mturk.model.primitives.EntityId
import scala.jdk.CollectionConverters._
final case class RejectAssignmentRequest(
    assignmentId: EntityId,
    requesterFeedback: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.RejectAssignmentRequest = {
    import RejectAssignmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.RejectAssignmentRequest
      .builder()
      .assignmentId(EntityId.unwrap(assignmentId): java.lang.String)
      .requesterFeedback(requesterFeedback: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mturk.model.RejectAssignmentRequest.ReadOnly =
    zio.aws.mturk.model.RejectAssignmentRequest.wrap(buildAwsValue())
}
object RejectAssignmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.RejectAssignmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.RejectAssignmentRequest =
      zio.aws.mturk.model
        .RejectAssignmentRequest(assignmentId, requesterFeedback)
    def assignmentId: EntityId
    def requesterFeedback: String
    def getAssignmentId: ZIO[Any, Nothing, EntityId] = ZIO.succeed(assignmentId)
    def getRequesterFeedback: ZIO[Any, Nothing, String] =
      ZIO.succeed(requesterFeedback)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.RejectAssignmentRequest
  ) extends zio.aws.mturk.model.RejectAssignmentRequest.ReadOnly {
    override val assignmentId: EntityId =
      zio.aws.mturk.model.primitives.EntityId(impl.assignmentId())
    override val requesterFeedback: String = impl.requesterFeedback(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.RejectAssignmentRequest
  ): zio.aws.mturk.model.RejectAssignmentRequest.ReadOnly = new Wrapper(impl)
}
