package zio.aws.mturk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mturk.model.primitives.{Timestamp, EntityId}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ReviewActionDetail(
    actionId: Option[EntityId] = None,
    actionName: Option[String] = None,
    targetId: Option[EntityId] = None,
    targetType: Option[String] = None,
    status: Option[zio.aws.mturk.model.ReviewActionStatus] = None,
    completeTime: Option[Timestamp] = None,
    result: Option[String] = None,
    errorCode: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.ReviewActionDetail = {
    import ReviewActionDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.ReviewActionDetail
      .builder()
      .optionallyWith(
        actionId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.actionId)
      .optionallyWith(actionName.map(value => value: java.lang.String))(
        _.actionName
      )
      .optionallyWith(
        targetId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.targetId)
      .optionallyWith(targetType.map(value => value: java.lang.String))(
        _.targetType
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        completeTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.completeTime)
      .optionallyWith(result.map(value => value: java.lang.String))(_.result)
      .optionallyWith(errorCode.map(value => value: java.lang.String))(
        _.errorCode
      )
      .build()
  }
  def asReadOnly: zio.aws.mturk.model.ReviewActionDetail.ReadOnly =
    zio.aws.mturk.model.ReviewActionDetail.wrap(buildAwsValue())
}
object ReviewActionDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.ReviewActionDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.ReviewActionDetail =
      zio.aws.mturk.model.ReviewActionDetail(
        actionId.map(value => value),
        actionName.map(value => value),
        targetId.map(value => value),
        targetType.map(value => value),
        status.map(value => value),
        completeTime.map(value => value),
        result.map(value => value),
        errorCode.map(value => value)
      )
    def actionId: Option[EntityId]
    def actionName: Option[String]
    def targetId: Option[EntityId]
    def targetType: Option[String]
    def status: Option[zio.aws.mturk.model.ReviewActionStatus]
    def completeTime: Option[Timestamp]
    def result: Option[String]
    def errorCode: Option[String]
    def getActionId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("actionId", actionId)
    def getActionName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("actionName", actionName)
    def getTargetId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("targetId", targetId)
    def getTargetType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("targetType", targetType)
    def getStatus: ZIO[Any, AwsError, zio.aws.mturk.model.ReviewActionStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCompleteTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("completeTime", completeTime)
    def getResult: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("result", result)
    def getErrorCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorCode", errorCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.ReviewActionDetail
  ) extends zio.aws.mturk.model.ReviewActionDetail.ReadOnly {
    override val actionId: Option[EntityId] = scala
      .Option(impl.actionId())
      .map(value => zio.aws.mturk.model.primitives.EntityId(value))
    override val actionName: Option[String] =
      scala.Option(impl.actionName()).map(value => value: String)
    override val targetId: Option[EntityId] = scala
      .Option(impl.targetId())
      .map(value => zio.aws.mturk.model.primitives.EntityId(value))
    override val targetType: Option[String] =
      scala.Option(impl.targetType()).map(value => value: String)
    override val status: Option[zio.aws.mturk.model.ReviewActionStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.mturk.model.ReviewActionStatus.wrap(value))
    override val completeTime: Option[Timestamp] = scala
      .Option(impl.completeTime())
      .map(value => zio.aws.mturk.model.primitives.Timestamp(value))
    override val result: Option[String] =
      scala.Option(impl.result()).map(value => value: String)
    override val errorCode: Option[String] =
      scala.Option(impl.errorCode()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.ReviewActionDetail
  ): zio.aws.mturk.model.ReviewActionDetail.ReadOnly = new Wrapper(impl)
}
