package zio.aws.mturk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ReviewPolicy(
    policyName: String,
    parameters: Option[Iterable[zio.aws.mturk.model.PolicyParameter]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.ReviewPolicy = {
    import ReviewPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.ReviewPolicy
      .builder()
      .policyName(policyName: java.lang.String)
      .optionallyWith(
        parameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameters)
      .build()
  }
  def asReadOnly: zio.aws.mturk.model.ReviewPolicy.ReadOnly =
    zio.aws.mturk.model.ReviewPolicy.wrap(buildAwsValue())
}
object ReviewPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.ReviewPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.ReviewPolicy =
      zio.aws.mturk.model.ReviewPolicy(
        policyName,
        parameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def policyName: String
    def parameters: Option[List[zio.aws.mturk.model.PolicyParameter.ReadOnly]]
    def getPolicyName: ZIO[Any, Nothing, String] = ZIO.succeed(policyName)
    def getParameters: ZIO[Any, AwsError, List[
      zio.aws.mturk.model.PolicyParameter.ReadOnly
    ]] = AwsError.unwrapOptionField("parameters", parameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.ReviewPolicy
  ) extends zio.aws.mturk.model.ReviewPolicy.ReadOnly {
    override val policyName: String = impl.policyName(): String
    override val parameters
        : Option[List[zio.aws.mturk.model.PolicyParameter.ReadOnly]] = scala
      .Option(impl.parameters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mturk.model.PolicyParameter.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.ReviewPolicy
  ): zio.aws.mturk.model.ReviewPolicy.ReadOnly = new Wrapper(impl)
}
