package zio.aws.mturk.model
import scala.jdk.CollectionConverters._
sealed trait ReviewPolicyLevel {
  def unwrap: software.amazon.awssdk.services.mturk.model.ReviewPolicyLevel
}
object ReviewPolicyLevel {
  def wrap(
      value: software.amazon.awssdk.services.mturk.model.ReviewPolicyLevel
  ): zio.aws.mturk.model.ReviewPolicyLevel = value match {
    case software.amazon.awssdk.services.mturk.model.ReviewPolicyLevel.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mturk.model.ReviewPolicyLevel.ASSIGNMENT =>
      val r = Assignment
      r
    case software.amazon.awssdk.services.mturk.model.ReviewPolicyLevel.HIT =>
      val r = HIT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.mturk.model.ReviewPolicyLevel {
    override def unwrap
        : software.amazon.awssdk.services.mturk.model.ReviewPolicyLevel =
      software.amazon.awssdk.services.mturk.model.ReviewPolicyLevel.UNKNOWN_TO_SDK_VERSION
  }
  case object Assignment extends zio.aws.mturk.model.ReviewPolicyLevel {
    override def unwrap
        : software.amazon.awssdk.services.mturk.model.ReviewPolicyLevel =
      software.amazon.awssdk.services.mturk.model.ReviewPolicyLevel.ASSIGNMENT
  }
  case object HIT extends zio.aws.mturk.model.ReviewPolicyLevel {
    override def unwrap
        : software.amazon.awssdk.services.mturk.model.ReviewPolicyLevel =
      software.amazon.awssdk.services.mturk.model.ReviewPolicyLevel.HIT
  }
}
