package zio.aws.mturk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ReviewReport(
    reviewResults: Option[Iterable[zio.aws.mturk.model.ReviewResultDetail]] =
      None,
    reviewActions: Option[Iterable[zio.aws.mturk.model.ReviewActionDetail]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.ReviewReport = {
    import ReviewReport.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.ReviewReport
      .builder()
      .optionallyWith(
        reviewResults.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.reviewResults)
      .optionallyWith(
        reviewActions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.reviewActions)
      .build()
  }
  def asReadOnly: zio.aws.mturk.model.ReviewReport.ReadOnly =
    zio.aws.mturk.model.ReviewReport.wrap(buildAwsValue())
}
object ReviewReport {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.ReviewReport
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.ReviewReport =
      zio.aws.mturk.model.ReviewReport(
        reviewResults.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        reviewActions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def reviewResults
        : Option[List[zio.aws.mturk.model.ReviewResultDetail.ReadOnly]]
    def reviewActions
        : Option[List[zio.aws.mturk.model.ReviewActionDetail.ReadOnly]]
    def getReviewResults: ZIO[Any, AwsError, List[
      zio.aws.mturk.model.ReviewResultDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("reviewResults", reviewResults)
    def getReviewActions: ZIO[Any, AwsError, List[
      zio.aws.mturk.model.ReviewActionDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("reviewActions", reviewActions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.ReviewReport
  ) extends zio.aws.mturk.model.ReviewReport.ReadOnly {
    override val reviewResults
        : Option[List[zio.aws.mturk.model.ReviewResultDetail.ReadOnly]] = scala
      .Option(impl.reviewResults())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mturk.model.ReviewResultDetail.wrap(item)
        }.toList
      )
    override val reviewActions
        : Option[List[zio.aws.mturk.model.ReviewActionDetail.ReadOnly]] = scala
      .Option(impl.reviewActions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mturk.model.ReviewActionDetail.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.ReviewReport
  ): zio.aws.mturk.model.ReviewReport.ReadOnly = new Wrapper(impl)
}
