package zio.aws.mturk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mturk.model.primitives.EntityId
import scala.jdk.CollectionConverters._
final case class ReviewResultDetail(
    actionId: Option[EntityId] = None,
    subjectId: Option[EntityId] = None,
    subjectType: Option[String] = None,
    questionId: Option[EntityId] = None,
    key: Option[String] = None,
    value: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.ReviewResultDetail = {
    import ReviewResultDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.ReviewResultDetail
      .builder()
      .optionallyWith(
        actionId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.actionId)
      .optionallyWith(
        subjectId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.subjectId)
      .optionallyWith(subjectType.map(value => value: java.lang.String))(
        _.subjectType
      )
      .optionallyWith(
        questionId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.questionId)
      .optionallyWith(key.map(value => value: java.lang.String))(_.key)
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .build()
  }
  def asReadOnly: zio.aws.mturk.model.ReviewResultDetail.ReadOnly =
    zio.aws.mturk.model.ReviewResultDetail.wrap(buildAwsValue())
}
object ReviewResultDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.ReviewResultDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.ReviewResultDetail =
      zio.aws.mturk.model.ReviewResultDetail(
        actionId.map(value => value),
        subjectId.map(value => value),
        subjectType.map(value => value),
        questionId.map(value => value),
        key.map(value => value),
        value.map(value => value)
      )
    def actionId: Option[EntityId]
    def subjectId: Option[EntityId]
    def subjectType: Option[String]
    def questionId: Option[EntityId]
    def key: Option[String]
    def value: Option[String]
    def getActionId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("actionId", actionId)
    def getSubjectId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("subjectId", subjectId)
    def getSubjectType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subjectType", subjectType)
    def getQuestionId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("questionId", questionId)
    def getKey: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("key", key)
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.ReviewResultDetail
  ) extends zio.aws.mturk.model.ReviewResultDetail.ReadOnly {
    override val actionId: Option[EntityId] = scala
      .Option(impl.actionId())
      .map(value => zio.aws.mturk.model.primitives.EntityId(value))
    override val subjectId: Option[EntityId] = scala
      .Option(impl.subjectId())
      .map(value => zio.aws.mturk.model.primitives.EntityId(value))
    override val subjectType: Option[String] =
      scala.Option(impl.subjectType()).map(value => value: String)
    override val questionId: Option[EntityId] = scala
      .Option(impl.questionId())
      .map(value => zio.aws.mturk.model.primitives.EntityId(value))
    override val key: Option[String] =
      scala.Option(impl.key()).map(value => value: String)
    override val value: Option[String] =
      scala.Option(impl.value()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.ReviewResultDetail
  ): zio.aws.mturk.model.ReviewResultDetail.ReadOnly = new Wrapper(impl)
}
