package zio.aws.mturk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mturk.model.primitives.{
  IdempotencyToken,
  EntityId,
  CurrencyAmount,
  CustomerId
}
import scala.jdk.CollectionConverters._
final case class SendBonusRequest(
    workerId: CustomerId,
    bonusAmount: CurrencyAmount,
    assignmentId: EntityId,
    reason: String,
    uniqueRequestToken: Option[IdempotencyToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.SendBonusRequest = {
    import SendBonusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.SendBonusRequest
      .builder()
      .workerId(CustomerId.unwrap(workerId): java.lang.String)
      .bonusAmount(CurrencyAmount.unwrap(bonusAmount): java.lang.String)
      .assignmentId(EntityId.unwrap(assignmentId): java.lang.String)
      .reason(reason: java.lang.String)
      .optionallyWith(
        uniqueRequestToken.map(value =>
          IdempotencyToken.unwrap(value): java.lang.String
        )
      )(_.uniqueRequestToken)
      .build()
  }
  def asReadOnly: zio.aws.mturk.model.SendBonusRequest.ReadOnly =
    zio.aws.mturk.model.SendBonusRequest.wrap(buildAwsValue())
}
object SendBonusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.SendBonusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.SendBonusRequest =
      zio.aws.mturk.model.SendBonusRequest(
        workerId,
        bonusAmount,
        assignmentId,
        reason,
        uniqueRequestToken.map(value => value)
      )
    def workerId: CustomerId
    def bonusAmount: CurrencyAmount
    def assignmentId: EntityId
    def reason: String
    def uniqueRequestToken: Option[IdempotencyToken]
    def getWorkerId: ZIO[Any, Nothing, CustomerId] = ZIO.succeed(workerId)
    def getBonusAmount: ZIO[Any, Nothing, CurrencyAmount] =
      ZIO.succeed(bonusAmount)
    def getAssignmentId: ZIO[Any, Nothing, EntityId] = ZIO.succeed(assignmentId)
    def getReason: ZIO[Any, Nothing, String] = ZIO.succeed(reason)
    def getUniqueRequestToken: ZIO[Any, AwsError, IdempotencyToken] =
      AwsError.unwrapOptionField("uniqueRequestToken", uniqueRequestToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.SendBonusRequest
  ) extends zio.aws.mturk.model.SendBonusRequest.ReadOnly {
    override val workerId: CustomerId =
      zio.aws.mturk.model.primitives.CustomerId(impl.workerId())
    override val bonusAmount: CurrencyAmount =
      zio.aws.mturk.model.primitives.CurrencyAmount(impl.bonusAmount())
    override val assignmentId: EntityId =
      zio.aws.mturk.model.primitives.EntityId(impl.assignmentId())
    override val reason: String = impl.reason(): String
    override val uniqueRequestToken: Option[IdempotencyToken] = scala
      .Option(impl.uniqueRequestToken())
      .map(value => zio.aws.mturk.model.primitives.IdempotencyToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.SendBonusRequest
  ): zio.aws.mturk.model.SendBonusRequest.ReadOnly = new Wrapper(impl)
}
