package zio.aws.mturk.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.mturk.model.primitives.{Timestamp, EntityId}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class UpdateExpirationForHitRequest(
    hitId: EntityId,
    expireAt: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.UpdateExpirationForHitRequest = {
    import UpdateExpirationForHitRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.UpdateExpirationForHitRequest
      .builder()
      .hitId(EntityId.unwrap(hitId): java.lang.String)
      .expireAt(Timestamp.unwrap(expireAt): Instant)
      .build()
  }
  def asReadOnly: zio.aws.mturk.model.UpdateExpirationForHitRequest.ReadOnly =
    zio.aws.mturk.model.UpdateExpirationForHitRequest.wrap(buildAwsValue())
}
object UpdateExpirationForHitRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.UpdateExpirationForHitRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.UpdateExpirationForHitRequest =
      zio.aws.mturk.model.UpdateExpirationForHitRequest(hitId, expireAt)
    def hitId: EntityId
    def expireAt: Timestamp
    def getHitId: ZIO[Any, Nothing, EntityId] = ZIO.succeed(hitId)
    def getExpireAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(expireAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.UpdateExpirationForHitRequest
  ) extends zio.aws.mturk.model.UpdateExpirationForHitRequest.ReadOnly {
    override val hitId: EntityId =
      zio.aws.mturk.model.primitives.EntityId(impl.hitId())
    override val expireAt: Timestamp =
      zio.aws.mturk.model.primitives.Timestamp(impl.expireAt())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.UpdateExpirationForHitRequest
  ): zio.aws.mturk.model.UpdateExpirationForHitRequest.ReadOnly = new Wrapper(
    impl
  )
}
