package zio.aws.mturk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mturk.model.primitives.EntityId
import scala.jdk.CollectionConverters._
final case class UpdateHitReviewStatusRequest(
    hitId: EntityId,
    revert: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.UpdateHitReviewStatusRequest = {
    import UpdateHitReviewStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.UpdateHitReviewStatusRequest
      .builder()
      .hitId(EntityId.unwrap(hitId): java.lang.String)
      .optionallyWith(revert.map(value => value: java.lang.Boolean))(_.revert)
      .build()
  }
  def asReadOnly: zio.aws.mturk.model.UpdateHitReviewStatusRequest.ReadOnly =
    zio.aws.mturk.model.UpdateHitReviewStatusRequest.wrap(buildAwsValue())
}
object UpdateHitReviewStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.UpdateHitReviewStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.UpdateHitReviewStatusRequest =
      zio.aws.mturk.model
        .UpdateHitReviewStatusRequest(hitId, revert.map(value => value))
    def hitId: EntityId
    def revert: Option[Boolean]
    def getHitId: ZIO[Any, Nothing, EntityId] = ZIO.succeed(hitId)
    def getRevert: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("revert", revert)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.UpdateHitReviewStatusRequest
  ) extends zio.aws.mturk.model.UpdateHitReviewStatusRequest.ReadOnly {
    override val hitId: EntityId =
      zio.aws.mturk.model.primitives.EntityId(impl.hitId())
    override val revert: Option[Boolean] =
      scala.Option(impl.revert()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.UpdateHitReviewStatusRequest
  ): zio.aws.mturk.model.UpdateHitReviewStatusRequest.ReadOnly = new Wrapper(
    impl
  )
}
