package zio.aws.mturk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mturk.model.primitives.EntityId
import scala.jdk.CollectionConverters._
final case class UpdateNotificationSettingsRequest(
    hitTypeId: EntityId,
    notification: Option[zio.aws.mturk.model.NotificationSpecification] = None,
    active: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.UpdateNotificationSettingsRequest = {
    import UpdateNotificationSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.UpdateNotificationSettingsRequest
      .builder()
      .hitTypeId(EntityId.unwrap(hitTypeId): java.lang.String)
      .optionallyWith(notification.map(value => value.buildAwsValue()))(
        _.notification
      )
      .optionallyWith(active.map(value => value: java.lang.Boolean))(_.active)
      .build()
  }
  def asReadOnly
      : zio.aws.mturk.model.UpdateNotificationSettingsRequest.ReadOnly =
    zio.aws.mturk.model.UpdateNotificationSettingsRequest.wrap(buildAwsValue())
}
object UpdateNotificationSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.UpdateNotificationSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.UpdateNotificationSettingsRequest =
      zio.aws.mturk.model.UpdateNotificationSettingsRequest(
        hitTypeId,
        notification.map(value => value.asEditable),
        active.map(value => value)
      )
    def hitTypeId: EntityId
    def notification
        : Option[zio.aws.mturk.model.NotificationSpecification.ReadOnly]
    def active: Option[Boolean]
    def getHitTypeId: ZIO[Any, Nothing, EntityId] = ZIO.succeed(hitTypeId)
    def getNotification: ZIO[
      Any,
      AwsError,
      zio.aws.mturk.model.NotificationSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("notification", notification)
    def getActive: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("active", active)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.UpdateNotificationSettingsRequest
  ) extends zio.aws.mturk.model.UpdateNotificationSettingsRequest.ReadOnly {
    override val hitTypeId: EntityId =
      zio.aws.mturk.model.primitives.EntityId(impl.hitTypeId())
    override val notification
        : Option[zio.aws.mturk.model.NotificationSpecification.ReadOnly] = scala
      .Option(impl.notification())
      .map(value => zio.aws.mturk.model.NotificationSpecification.wrap(value))
    override val active: Option[Boolean] =
      scala.Option(impl.active()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.UpdateNotificationSettingsRequest
  ): zio.aws.mturk.model.UpdateNotificationSettingsRequest.ReadOnly =
    new Wrapper(impl)
}
