package zio.aws.mturk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mturk.model.primitives.{Integer, EntityId}
import scala.jdk.CollectionConverters._
final case class UpdateQualificationTypeRequest(
    qualificationTypeId: EntityId,
    description: Option[String] = None,
    qualificationTypeStatus: Option[
      zio.aws.mturk.model.QualificationTypeStatus
    ] = None,
    test: Option[String] = None,
    answerKey: Option[String] = None,
    testDurationInSeconds: Option[Long] = None,
    retryDelayInSeconds: Option[Long] = None,
    autoGranted: Option[Boolean] = None,
    autoGrantedValue: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.UpdateQualificationTypeRequest = {
    import UpdateQualificationTypeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.UpdateQualificationTypeRequest
      .builder()
      .qualificationTypeId(
        EntityId.unwrap(qualificationTypeId): java.lang.String
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(qualificationTypeStatus.map(value => value.unwrap))(
        _.qualificationTypeStatus
      )
      .optionallyWith(test.map(value => value: java.lang.String))(_.test)
      .optionallyWith(answerKey.map(value => value: java.lang.String))(
        _.answerKey
      )
      .optionallyWith(
        testDurationInSeconds.map(value => value: java.lang.Long)
      )(_.testDurationInSeconds)
      .optionallyWith(retryDelayInSeconds.map(value => value: java.lang.Long))(
        _.retryDelayInSeconds
      )
      .optionallyWith(autoGranted.map(value => value: java.lang.Boolean))(
        _.autoGranted
      )
      .optionallyWith(autoGrantedValue.map(value => value: java.lang.Integer))(
        _.autoGrantedValue
      )
      .build()
  }
  def asReadOnly: zio.aws.mturk.model.UpdateQualificationTypeRequest.ReadOnly =
    zio.aws.mturk.model.UpdateQualificationTypeRequest.wrap(buildAwsValue())
}
object UpdateQualificationTypeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.UpdateQualificationTypeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.UpdateQualificationTypeRequest =
      zio.aws.mturk.model.UpdateQualificationTypeRequest(
        qualificationTypeId,
        description.map(value => value),
        qualificationTypeStatus.map(value => value),
        test.map(value => value),
        answerKey.map(value => value),
        testDurationInSeconds.map(value => value),
        retryDelayInSeconds.map(value => value),
        autoGranted.map(value => value),
        autoGrantedValue.map(value => value)
      )
    def qualificationTypeId: EntityId
    def description: Option[String]
    def qualificationTypeStatus
        : Option[zio.aws.mturk.model.QualificationTypeStatus]
    def test: Option[String]
    def answerKey: Option[String]
    def testDurationInSeconds: Option[Long]
    def retryDelayInSeconds: Option[Long]
    def autoGranted: Option[Boolean]
    def autoGrantedValue: Option[Integer]
    def getQualificationTypeId: ZIO[Any, Nothing, EntityId] =
      ZIO.succeed(qualificationTypeId)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getQualificationTypeStatus
        : ZIO[Any, AwsError, zio.aws.mturk.model.QualificationTypeStatus] =
      AwsError.unwrapOptionField(
        "qualificationTypeStatus",
        qualificationTypeStatus
      )
    def getTest: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("test", test)
    def getAnswerKey: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("answerKey", answerKey)
    def getTestDurationInSeconds: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("testDurationInSeconds", testDurationInSeconds)
    def getRetryDelayInSeconds: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("retryDelayInSeconds", retryDelayInSeconds)
    def getAutoGranted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("autoGranted", autoGranted)
    def getAutoGrantedValue: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("autoGrantedValue", autoGrantedValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.UpdateQualificationTypeRequest
  ) extends zio.aws.mturk.model.UpdateQualificationTypeRequest.ReadOnly {
    override val qualificationTypeId: EntityId =
      zio.aws.mturk.model.primitives.EntityId(impl.qualificationTypeId())
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val qualificationTypeStatus
        : Option[zio.aws.mturk.model.QualificationTypeStatus] = scala
      .Option(impl.qualificationTypeStatus())
      .map(value => zio.aws.mturk.model.QualificationTypeStatus.wrap(value))
    override val test: Option[String] =
      scala.Option(impl.test()).map(value => value: String)
    override val answerKey: Option[String] =
      scala.Option(impl.answerKey()).map(value => value: String)
    override val testDurationInSeconds: Option[Long] =
      scala.Option(impl.testDurationInSeconds()).map(value => value: Long)
    override val retryDelayInSeconds: Option[Long] =
      scala.Option(impl.retryDelayInSeconds()).map(value => value: Long)
    override val autoGranted: Option[Boolean] =
      scala.Option(impl.autoGranted()).map(value => value: Boolean)
    override val autoGrantedValue: Option[Integer] =
      scala.Option(impl.autoGrantedValue()).map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.UpdateQualificationTypeRequest
  ): zio.aws.mturk.model.UpdateQualificationTypeRequest.ReadOnly = new Wrapper(
    impl
  )
}
