package zio.aws.mturk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mturk.model.primitives.CustomerId
import scala.jdk.CollectionConverters._
final case class WorkerBlock(
    workerId: Option[CustomerId] = None,
    reason: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.WorkerBlock = {
    import WorkerBlock.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.WorkerBlock
      .builder()
      .optionallyWith(
        workerId.map(value => CustomerId.unwrap(value): java.lang.String)
      )(_.workerId)
      .optionallyWith(reason.map(value => value: java.lang.String))(_.reason)
      .build()
  }
  def asReadOnly: zio.aws.mturk.model.WorkerBlock.ReadOnly =
    zio.aws.mturk.model.WorkerBlock.wrap(buildAwsValue())
}
object WorkerBlock {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.mturk.model.WorkerBlock] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.WorkerBlock = zio.aws.mturk.model
      .WorkerBlock(workerId.map(value => value), reason.map(value => value))
    def workerId: Option[CustomerId]
    def reason: Option[String]
    def getWorkerId: ZIO[Any, AwsError, CustomerId] =
      AwsError.unwrapOptionField("workerId", workerId)
    def getReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("reason", reason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.WorkerBlock
  ) extends zio.aws.mturk.model.WorkerBlock.ReadOnly {
    override val workerId: Option[CustomerId] = scala
      .Option(impl.workerId())
      .map(value => zio.aws.mturk.model.primitives.CustomerId(value))
    override val reason: Option[String] =
      scala.Option(impl.reason()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.WorkerBlock
  ): zio.aws.mturk.model.WorkerBlock.ReadOnly = new Wrapper(impl)
}
