package zio.aws.mturk.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.mturk.model.primitives.{
  Timestamp,
  EntityId,
  CurrencyAmount,
  CustomerId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class BonusPayment(
    workerId: Optional[CustomerId] = Optional.Absent,
    bonusAmount: Optional[CurrencyAmount] = Optional.Absent,
    assignmentId: Optional[EntityId] = Optional.Absent,
    reason: Optional[String] = Optional.Absent,
    grantTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.BonusPayment = {
    import BonusPayment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.BonusPayment
      .builder()
      .optionallyWith(
        workerId.map(value => CustomerId.unwrap(value): java.lang.String)
      )(_.workerId)
      .optionallyWith(
        bonusAmount.map(value => CurrencyAmount.unwrap(value): java.lang.String)
      )(_.bonusAmount)
      .optionallyWith(
        assignmentId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.assignmentId)
      .optionallyWith(reason.map(value => value: java.lang.String))(_.reason)
      .optionallyWith(grantTime.map(value => Timestamp.unwrap(value): Instant))(
        _.grantTime
      )
      .build()
  }
  def asReadOnly: zio.aws.mturk.model.BonusPayment.ReadOnly =
    zio.aws.mturk.model.BonusPayment.wrap(buildAwsValue())
}
object BonusPayment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.BonusPayment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.BonusPayment =
      zio.aws.mturk.model.BonusPayment(
        workerId.map(value => value),
        bonusAmount.map(value => value),
        assignmentId.map(value => value),
        reason.map(value => value),
        grantTime.map(value => value)
      )
    def workerId: Optional[CustomerId]
    def bonusAmount: Optional[CurrencyAmount]
    def assignmentId: Optional[EntityId]
    def reason: Optional[String]
    def grantTime: Optional[Timestamp]
    def getWorkerId: ZIO[Any, AwsError, CustomerId] =
      AwsError.unwrapOptionField("workerId", workerId)
    def getBonusAmount: ZIO[Any, AwsError, CurrencyAmount] =
      AwsError.unwrapOptionField("bonusAmount", bonusAmount)
    def getAssignmentId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("assignmentId", assignmentId)
    def getReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("reason", reason)
    def getGrantTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("grantTime", grantTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.BonusPayment
  ) extends zio.aws.mturk.model.BonusPayment.ReadOnly {
    override val workerId: Optional[CustomerId] = zio.aws.core.internal
      .optionalFromNullable(impl.workerId())
      .map(value => zio.aws.mturk.model.primitives.CustomerId(value))
    override val bonusAmount: Optional[CurrencyAmount] = zio.aws.core.internal
      .optionalFromNullable(impl.bonusAmount())
      .map(value => zio.aws.mturk.model.primitives.CurrencyAmount(value))
    override val assignmentId: Optional[EntityId] = zio.aws.core.internal
      .optionalFromNullable(impl.assignmentId())
      .map(value => zio.aws.mturk.model.primitives.EntityId(value))
    override val reason: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.reason())
      .map(value => value: String)
    override val grantTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.grantTime())
      .map(value => zio.aws.mturk.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.BonusPayment
  ): zio.aws.mturk.model.BonusPayment.ReadOnly = new Wrapper(impl)
}
