package zio.aws.mturk.model
import scala.jdk.CollectionConverters._
sealed trait Comparator {
  def unwrap: software.amazon.awssdk.services.mturk.model.Comparator
}
object Comparator {
  def wrap(
      value: software.amazon.awssdk.services.mturk.model.Comparator
  ): zio.aws.mturk.model.Comparator = value match {
    case software.amazon.awssdk.services.mturk.model.Comparator.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mturk.model.Comparator.LESS_THAN =>
      val r = LessThan
      r
    case software.amazon.awssdk.services.mturk.model.Comparator.LESS_THAN_OR_EQUAL_TO =>
      val r = LessThanOrEqualTo
      r
    case software.amazon.awssdk.services.mturk.model.Comparator.GREATER_THAN =>
      val r = GreaterThan
      r
    case software.amazon.awssdk.services.mturk.model.Comparator.GREATER_THAN_OR_EQUAL_TO =>
      val r = GreaterThanOrEqualTo
      r
    case software.amazon.awssdk.services.mturk.model.Comparator.EQUAL_TO =>
      val r = EqualTo
      r
    case software.amazon.awssdk.services.mturk.model.Comparator.NOT_EQUAL_TO =>
      val r = NotEqualTo
      r
    case software.amazon.awssdk.services.mturk.model.Comparator.EXISTS =>
      val r = Exists
      r
    case software.amazon.awssdk.services.mturk.model.Comparator.DOES_NOT_EXIST =>
      val r = DoesNotExist
      r
    case software.amazon.awssdk.services.mturk.model.Comparator.IN =>
      val r = In
      r
    case software.amazon.awssdk.services.mturk.model.Comparator.NOT_IN =>
      val r = NotIn
      r
  }
  case object unknownToSdkVersion extends zio.aws.mturk.model.Comparator {
    override def unwrap
        : software.amazon.awssdk.services.mturk.model.Comparator =
      software.amazon.awssdk.services.mturk.model.Comparator.UNKNOWN_TO_SDK_VERSION
  }
  case object LessThan extends zio.aws.mturk.model.Comparator {
    override def unwrap
        : software.amazon.awssdk.services.mturk.model.Comparator =
      software.amazon.awssdk.services.mturk.model.Comparator.LESS_THAN
  }
  case object LessThanOrEqualTo extends zio.aws.mturk.model.Comparator {
    override def unwrap
        : software.amazon.awssdk.services.mturk.model.Comparator =
      software.amazon.awssdk.services.mturk.model.Comparator.LESS_THAN_OR_EQUAL_TO
  }
  case object GreaterThan extends zio.aws.mturk.model.Comparator {
    override def unwrap
        : software.amazon.awssdk.services.mturk.model.Comparator =
      software.amazon.awssdk.services.mturk.model.Comparator.GREATER_THAN
  }
  case object GreaterThanOrEqualTo extends zio.aws.mturk.model.Comparator {
    override def unwrap
        : software.amazon.awssdk.services.mturk.model.Comparator =
      software.amazon.awssdk.services.mturk.model.Comparator.GREATER_THAN_OR_EQUAL_TO
  }
  case object EqualTo extends zio.aws.mturk.model.Comparator {
    override def unwrap
        : software.amazon.awssdk.services.mturk.model.Comparator =
      software.amazon.awssdk.services.mturk.model.Comparator.EQUAL_TO
  }
  case object NotEqualTo extends zio.aws.mturk.model.Comparator {
    override def unwrap
        : software.amazon.awssdk.services.mturk.model.Comparator =
      software.amazon.awssdk.services.mturk.model.Comparator.NOT_EQUAL_TO
  }
  case object Exists extends zio.aws.mturk.model.Comparator {
    override def unwrap
        : software.amazon.awssdk.services.mturk.model.Comparator =
      software.amazon.awssdk.services.mturk.model.Comparator.EXISTS
  }
  case object DoesNotExist extends zio.aws.mturk.model.Comparator {
    override def unwrap
        : software.amazon.awssdk.services.mturk.model.Comparator =
      software.amazon.awssdk.services.mturk.model.Comparator.DOES_NOT_EXIST
  }
  case object In extends zio.aws.mturk.model.Comparator {
    override def unwrap
        : software.amazon.awssdk.services.mturk.model.Comparator =
      software.amazon.awssdk.services.mturk.model.Comparator.IN
  }
  case object NotIn extends zio.aws.mturk.model.Comparator {
    override def unwrap
        : software.amazon.awssdk.services.mturk.model.Comparator =
      software.amazon.awssdk.services.mturk.model.Comparator.NOT_IN
  }
}
