package zio.aws.mturk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mturk.model.primitives.EntityId
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateHitTypeResponse(
    hitTypeId: Optional[EntityId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.CreateHitTypeResponse = {
    import CreateHitTypeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.CreateHitTypeResponse
      .builder()
      .optionallyWith(
        hitTypeId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.hitTypeId)
      .build()
  }
  def asReadOnly: zio.aws.mturk.model.CreateHitTypeResponse.ReadOnly =
    zio.aws.mturk.model.CreateHitTypeResponse.wrap(buildAwsValue())
}
object CreateHitTypeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.CreateHitTypeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.CreateHitTypeResponse =
      zio.aws.mturk.model.CreateHitTypeResponse(hitTypeId.map(value => value))
    def hitTypeId: Optional[EntityId]
    def getHitTypeId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("hitTypeId", hitTypeId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.CreateHitTypeResponse
  ) extends zio.aws.mturk.model.CreateHitTypeResponse.ReadOnly {
    override val hitTypeId: Optional[EntityId] = zio.aws.core.internal
      .optionalFromNullable(impl.hitTypeId())
      .map(value => zio.aws.mturk.model.primitives.EntityId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.CreateHitTypeResponse
  ): zio.aws.mturk.model.CreateHitTypeResponse.ReadOnly = new Wrapper(impl)
}
