package zio.aws.mturk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mturk.model.primitives.Integer
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateQualificationTypeRequest(
    name: String,
    keywords: Optional[String] = Optional.Absent,
    description: String,
    qualificationTypeStatus: zio.aws.mturk.model.QualificationTypeStatus,
    retryDelayInSeconds: Optional[Long] = Optional.Absent,
    test: Optional[String] = Optional.Absent,
    answerKey: Optional[String] = Optional.Absent,
    testDurationInSeconds: Optional[Long] = Optional.Absent,
    autoGranted: Optional[Boolean] = Optional.Absent,
    autoGrantedValue: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.CreateQualificationTypeRequest = {
    import CreateQualificationTypeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.CreateQualificationTypeRequest
      .builder()
      .name(name: java.lang.String)
      .optionallyWith(keywords.map(value => value: java.lang.String))(
        _.keywords
      )
      .description(description: java.lang.String)
      .qualificationTypeStatus(qualificationTypeStatus.unwrap)
      .optionallyWith(retryDelayInSeconds.map(value => value: java.lang.Long))(
        _.retryDelayInSeconds
      )
      .optionallyWith(test.map(value => value: java.lang.String))(_.test)
      .optionallyWith(answerKey.map(value => value: java.lang.String))(
        _.answerKey
      )
      .optionallyWith(
        testDurationInSeconds.map(value => value: java.lang.Long)
      )(_.testDurationInSeconds)
      .optionallyWith(autoGranted.map(value => value: java.lang.Boolean))(
        _.autoGranted
      )
      .optionallyWith(autoGrantedValue.map(value => value: java.lang.Integer))(
        _.autoGrantedValue
      )
      .build()
  }
  def asReadOnly: zio.aws.mturk.model.CreateQualificationTypeRequest.ReadOnly =
    zio.aws.mturk.model.CreateQualificationTypeRequest.wrap(buildAwsValue())
}
object CreateQualificationTypeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.CreateQualificationTypeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.CreateQualificationTypeRequest =
      zio.aws.mturk.model.CreateQualificationTypeRequest(
        name,
        keywords.map(value => value),
        description,
        qualificationTypeStatus,
        retryDelayInSeconds.map(value => value),
        test.map(value => value),
        answerKey.map(value => value),
        testDurationInSeconds.map(value => value),
        autoGranted.map(value => value),
        autoGrantedValue.map(value => value)
      )
    def name: String
    def keywords: Optional[String]
    def description: String
    def qualificationTypeStatus: zio.aws.mturk.model.QualificationTypeStatus
    def retryDelayInSeconds: Optional[Long]
    def test: Optional[String]
    def answerKey: Optional[String]
    def testDurationInSeconds: Optional[Long]
    def autoGranted: Optional[Boolean]
    def autoGrantedValue: Optional[Integer]
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getKeywords: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("keywords", keywords)
    def getDescription: ZIO[Any, Nothing, String] = ZIO.succeed(description)
    def getQualificationTypeStatus
        : ZIO[Any, Nothing, zio.aws.mturk.model.QualificationTypeStatus] =
      ZIO.succeed(qualificationTypeStatus)
    def getRetryDelayInSeconds: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("retryDelayInSeconds", retryDelayInSeconds)
    def getTest: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("test", test)
    def getAnswerKey: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("answerKey", answerKey)
    def getTestDurationInSeconds: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("testDurationInSeconds", testDurationInSeconds)
    def getAutoGranted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("autoGranted", autoGranted)
    def getAutoGrantedValue: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("autoGrantedValue", autoGrantedValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.CreateQualificationTypeRequest
  ) extends zio.aws.mturk.model.CreateQualificationTypeRequest.ReadOnly {
    override val name: String = impl.name(): String
    override val keywords: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.keywords())
      .map(value => value: String)
    override val description: String = impl.description(): String
    override val qualificationTypeStatus
        : zio.aws.mturk.model.QualificationTypeStatus =
      zio.aws.mturk.model.QualificationTypeStatus
        .wrap(impl.qualificationTypeStatus())
    override val retryDelayInSeconds: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.retryDelayInSeconds())
      .map(value => value: Long)
    override val test: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.test())
      .map(value => value: String)
    override val answerKey: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.answerKey())
      .map(value => value: String)
    override val testDurationInSeconds: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.testDurationInSeconds())
      .map(value => value: Long)
    override val autoGranted: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.autoGranted())
      .map(value => value: Boolean)
    override val autoGrantedValue: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.autoGrantedValue())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.CreateQualificationTypeRequest
  ): zio.aws.mturk.model.CreateQualificationTypeRequest.ReadOnly = new Wrapper(
    impl
  )
}
