package zio.aws.mturk.model
import zio.prelude.data.Optional
import zio.aws.mturk.model.primitives.{ResultSize, PaginationToken, EntityId}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListAssignmentsForHitRequest(
    hitId: EntityId,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    maxResults: Optional[ResultSize] = Optional.Absent,
    assignmentStatuses: Optional[
      Iterable[zio.aws.mturk.model.AssignmentStatus]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.ListAssignmentsForHitRequest = {
    import ListAssignmentsForHitRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.ListAssignmentsForHitRequest
      .builder()
      .hitId(EntityId.unwrap(hitId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => ResultSize.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        assignmentStatuses.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.assignmentStatusesWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.mturk.model.ListAssignmentsForHitRequest.ReadOnly =
    zio.aws.mturk.model.ListAssignmentsForHitRequest.wrap(buildAwsValue())
}
object ListAssignmentsForHitRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.ListAssignmentsForHitRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.ListAssignmentsForHitRequest =
      zio.aws.mturk.model.ListAssignmentsForHitRequest(
        hitId,
        nextToken.map(value => value),
        maxResults.map(value => value),
        assignmentStatuses.map(value => value)
      )
    def hitId: EntityId
    def nextToken: Optional[PaginationToken]
    def maxResults: Optional[ResultSize]
    def assignmentStatuses: Optional[List[zio.aws.mturk.model.AssignmentStatus]]
    def getHitId: ZIO[Any, Nothing, EntityId] = ZIO.succeed(hitId)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, ResultSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getAssignmentStatuses
        : ZIO[Any, AwsError, List[zio.aws.mturk.model.AssignmentStatus]] =
      AwsError.unwrapOptionField("assignmentStatuses", assignmentStatuses)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.ListAssignmentsForHitRequest
  ) extends zio.aws.mturk.model.ListAssignmentsForHitRequest.ReadOnly {
    override val hitId: EntityId =
      zio.aws.mturk.model.primitives.EntityId(impl.hitId())
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.mturk.model.primitives.PaginationToken(value))
    override val maxResults: Optional[ResultSize] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.mturk.model.primitives.ResultSize(value))
    override val assignmentStatuses
        : Optional[List[zio.aws.mturk.model.AssignmentStatus]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.assignmentStatuses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.mturk.model.AssignmentStatus.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.ListAssignmentsForHitRequest
  ): zio.aws.mturk.model.ListAssignmentsForHitRequest.ReadOnly = new Wrapper(
    impl
  )
}
