package zio.aws.mturk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mturk.model.primitives.{Integer, PaginationToken}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListAssignmentsForHitResponse(
    nextToken: Optional[PaginationToken] = Optional.Absent,
    numResults: Optional[Integer] = Optional.Absent,
    assignments: Optional[Iterable[zio.aws.mturk.model.Assignment]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.ListAssignmentsForHitResponse = {
    import ListAssignmentsForHitResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.ListAssignmentsForHitResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(numResults.map(value => value: java.lang.Integer))(
        _.numResults
      )
      .optionallyWith(
        assignments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.assignments)
      .build()
  }
  def asReadOnly: zio.aws.mturk.model.ListAssignmentsForHitResponse.ReadOnly =
    zio.aws.mturk.model.ListAssignmentsForHitResponse.wrap(buildAwsValue())
}
object ListAssignmentsForHitResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.ListAssignmentsForHitResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.ListAssignmentsForHitResponse =
      zio.aws.mturk.model.ListAssignmentsForHitResponse(
        nextToken.map(value => value),
        numResults.map(value => value),
        assignments.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[PaginationToken]
    def numResults: Optional[Integer]
    def assignments: Optional[List[zio.aws.mturk.model.Assignment.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getNumResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("numResults", numResults)
    def getAssignments
        : ZIO[Any, AwsError, List[zio.aws.mturk.model.Assignment.ReadOnly]] =
      AwsError.unwrapOptionField("assignments", assignments)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.ListAssignmentsForHitResponse
  ) extends zio.aws.mturk.model.ListAssignmentsForHitResponse.ReadOnly {
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.mturk.model.primitives.PaginationToken(value))
    override val numResults: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.numResults())
      .map(value => value: Integer)
    override val assignments
        : Optional[List[zio.aws.mturk.model.Assignment.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.assignments())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.mturk.model.Assignment.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.ListAssignmentsForHitResponse
  ): zio.aws.mturk.model.ListAssignmentsForHitResponse.ReadOnly = new Wrapper(
    impl
  )
}
